import React from 'react'
import { Radio } from 'antd-mobile'
import Label from '../common/label'

export default class CheckboxNormal extends React.Component {
  componentDidMount() {}

  handleChange = value => {
    this.props.onChange(value)
  }

  render() {
    const { title, options, childType } = this.props.formAttrs
    const { layout } = this.props

    // 自定义下拉选项
    let radioOptions = options ? options.split('\n') : []
    if (radioOptions) {
      radioOptions = radioOptions.map(item => {
        return {
          label: item,
          value: item
        }
      })
    }

    return (
      <div className="list-input-item">
        <div className="list-input-item-label">
          <Label layout={layout} type={childType}>
            {title}
          </Label>
        </div>
        <div className="list-input-item-content">
          {radioOptions.map(i => (
            <Radio
              className="radio-tag"
              key={i.value}
              checked={this.props.value === i.value}
              onChange={() => this.handleChange(i.value)}
            >
              <span className="radio-value">{i.value}</span>
            </Radio>
          ))}
        </div>
      </div>
    )
  }
}
