import React from 'react'
import RadioGroup from './radio-group'
import { verifyRules } from '../../verify'

export default class RadioNormal extends React.Component {
  componentDidMount() {}

  handleChange = value => {
    this.props.onChange && this.props.onChange(value)
  }

  render() {
    const { getFieldDecorator } = this.props.form
    const {
      type,
      childType,
      title,
      required,
      verify,
      options,
      key
    } = this.props.formAttrs
    const fieldId = `${type}_${childType}-${key}`

    return (
      <React.Fragment>
        {getFieldDecorator(fieldId, {
          rules: verifyRules(title, required, verify),
          initialValue: options ? options.split('\n')[0] : ''
        })(
          <RadioGroup {...this.props} onChange={this.handleChange.bind(this)} />
        )}
      </React.Fragment>
    )
  }
}
