import React from 'react'
import { InputItem, Flex } from 'antd-mobile'

import utils from '../../libs/utils'
import toast from '../../libs/toast'
import Label from '../common/label'

import styles from './index.less'
export default class InputNormal extends React.Component {
  componentDidMount() {}
  phone = ''
  state = {
    timeout: 0
  }
  handleChange = phone => {
    this.phone = phone
  }
  handleSend = fieldId => {
    const { getFieldError } = this.props.form
    let errors = getFieldError(fieldId)
    console.log(errors)
    if (errors) return toast(errors)
    utils
      .ajax({
        url: '/activity/land/sendCode',
        params: {
          phone: this.phone,
          landId: parseInt(window.atob(utils.getUrlParameter('id'))),
          landSubId: window.atob(utils.getUrlParameter('id')) + '-1',
          channel: 'formTemplate'
        }
      })
      .then(res => {
        if (res.success) {
          toast('发送验证码成功')
          this.setState(
            {
              timeout: 60
            },
            () => {
              this.runTimer()
            }
          )
        } else {
          toast(res.desc)
        }
      })
  }
  showError = errors => {
    toast(errors[0])
  }
  runTimer() {
    const { timeout } = this.state
    if (!timeout) {
      return
    }
    setTimeout(() => {
      this.setState({ timeout: this.state.timeout - 1 })
      this.runTimer()
    }, 1000)
  }
  render() {
    const { getFieldDecorator, getFieldError } = this.props.form
    const {
      type,
      childType,
      placeholder,
      title,
      sendVerifyCode,
      key
    } = this.props.formAttrs
    const { layout } = this.props
    const { timeout } = this.state
    const fieldId = `${type}_${childType}-${key}`
    const codeFieldId = `${type}_${childType}_code-${key}`
    return (
      <div>
        {getFieldDecorator(fieldId, {
          validateTrigger: 'onBlur',
          rules: [
            {
              pattern: /^(0|86|17951)?(13[0-9]|15[012356789]|166|17[3678]|18[0-9]|14[57])[0-9]{8}$/,
              required: true,
              message: '请输入正确的手机号'
            }
          ]
        })(
          <InputItem
            placeholder={placeholder}
            onChange={this.handleChange}
            error={!!getFieldError(fieldId)}
            onErrorClick={() => this.showError(getFieldError(fieldId))}
          >
            <Label layout={layout} type={childType}>
              {title}
            </Label>
          </InputItem>
        )}

        {sendVerifyCode ? (
          <Flex>
            {getFieldDecorator(codeFieldId, {
              validateTrigger: 'onBlur',
              rules: [
                {
                  pattern: /^\d{6}$/,
                  required: true,
                  message: '请输入正确的验证码'
                }
              ]
            })(
              <InputItem
                className={styles.code_input}
                placeholder="请输入验证码"
                error={!!getFieldError(fieldId + '_code')}
                onErrorClick={() =>
                  this.showError(getFieldError(fieldId + '_code'))
                }
              >
                <Label layout={layout} type={'verifi'}>
                  验证码
                </Label>
              </InputItem>
            )}
            {timeout ? (
              <div className={styles.timeout}>{timeout}s</div>
            ) : (
              <div
                className={styles.code_btn}
                onClick={() => this.handleSend(fieldId)}
              >
                发送验证码
              </div>
            )}
          </Flex>
        ) : (
          ''
        )}
      </div>
    )
  }
}
