import React, { Component } from 'react'
import { Form, Tabs, Row, Col, Button, Modal, Icon } from 'antd'
import styles from '../edits.less'
import { FormType as type } from 'wp/utils/itemType'
import editor from 'wp/constructors/editor/index'
import { inject, observer } from 'mobx-react'
import ModalContent from './modal-content'
// import { twinklingDomGen } from 'pro/lib/helper'

// const twinklingDom = twinklingDomGen()

const TabPane = Tabs.TabPane

// const SupportMultiple = [
//   'textarea_normal',
//   'checkbox_normal',
//   'radio_normal',
//   'select_customize',
//   'input_normal'
// ]

@editor({
  type,
  basic: {
    border: 'hidden',
    transform: 'hidden',
    borderRadius: 'hidden',
    opacity: 'hidden',
    rotate: 'hidden'
  }
})
@inject('WPSceneStore')
@observer
export default class FormEditor extends Component {
  state = {
    modalVisible: false
  }
  cancelHandler = () => {
    // const { target } = this.props
    // const { controlSetting } = target

    // let length = controlSetting.length
    // let duplicates = []
    // for (let i = length - 1; i >= 0; i--) {
    //   let left = controlSetting[i]
    //   for (let j = i - 1; j >= 0; j--) {
    //     let right = controlSetting[j]
    //     if (
    //       left['type'] === right['type'] &&
    //       left['childType'] === right['childType'] &&
    //       (!SupportMultiple.find(item => {
    //         return item === `${left['type']}_${left['childType']}`
    //       }) ||
    //         left['title'] === right['title'])
    //     ) {
    //       duplicates.push(right)
    //     }
    //   }
    //   // 如果存在相同的项
    //   if (duplicates.length > 0) {
    //     duplicates.push(left)
    //     break
    //   }
    // }
    // if (duplicates.length) {
    //   let attrName = 'data-row-key'
    //   let doms = []
    //   duplicates.forEach(item =>
    //     doms.push(document.querySelector(`[${attrName}="${item.key}"]`))
    //   )
    //   console.log(duplicates, doms)
    //   message.warning('相同表单项只能存在一项')
    //   // twinklingDomGen()({ dom: doms[0], r: 87, g: 140, b: 254 })
    //   doms.forEach(dom => twinklingDom({ dom, r: 87, g: 140, b: 254 }))
    // } else {
    //   this.setState({ modalVisible: false })
    // }

    this.setState({ modalVisible: false })
  }
  render() {
    const { target, BasicAttrsCom, WidgetNameCom, handleChange } = this.props
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="组件" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Row style={{ marginBottom: 12 }}>
                <Col offset={1}>
                  <Button
                    type="primary"
                    onClick={() => this.setState({ modalVisible: true })}
                  >
                    编辑组件
                  </Button>
                </Col>
              </Row>
              {BasicAttrsCom}
              <Modal
                width={800}
                wrapClassName="SettingModal formSettingModal"
                onCancel={this.cancelHandler}
                title={
                  <div
                    style={{
                      display: 'flex',
                      justifyContent: 'space-between',
                      alignItems: 'center',
                      height: '100%'
                    }}
                  >
                    编辑组件
                    <Icon
                      type="close"
                      onClick={this.cancelHandler}
                      style={{ cursor: 'pointer' }}
                    />
                  </div>
                }
                visible={this.state.modalVisible}
                footer={null}
                maskStyle={{ visibility: 'hidden' }}
              >
                <ModalContent target={target} handleChange={handleChange} />
              </Modal>
            </Form>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
