import React, { Component } from 'react'
import { Modal } from 'antd'
import CodeMirror from 'react-codemirror'
import 'codemirror/lib/codemirror.css'
import { observer } from 'mobx-react'

@observer
export default class extends Component {
  state = {
    modalVisible: false
  }
  render() {
    const { target, handleChange } = this.props
    return (
      <div>
        <a
          href="javascript:;"
          onClick={() => this.setState({ modalVisible: true })}
        >
          查看
        </a>
        <Modal
          title={null}
          footer={null}
          visible={this.state.modalVisible}
          bodyStyle={{ padding: 0 }}
          onCancel={() => this.setState({ modalVisible: false })}
        >
          <CodeMirror
            value={JSON.stringify(target.code, null, 2)}
            onChange={newCode => {
              handleChange({ code: JSON.parse(newCode) })
            }}
            options={{
              mode: 'javascript',
              lineNumbers: true
            }}
          />
        </Modal>
      </div>
    )
  }
}
