import React, { Component } from 'react'
import AMap from 'pro/components/amap'
import Cover from 'wp/constructors/fc/cover'

export default class AddressElement extends Component {
  reSetMarker = lnglat => {
    for (var i = 0; i < 2; i++) {
      if (
        (this.lnglat && this.lnglat[i] && this.lnglat[i] === lnglat[i]) ||
        !lnglat
      ) {
        return
      }
    }
    this.marker && this.marker.setMap(null)
    this.marker = new window.AMap.Marker({
      icon: 'https://webapi.amap.com/theme/v1.3/markers/n/mark_b.png',
      position: lnglat
    })
    this.marker.setMap(this.map)
    this.map.setZoomAndCenter(14, lnglat)
    this.lnglat = lnglat
  }
  render() {
    const { lnglat, address } = this.props.widgetAttrs
    const { showType } = address

    setTimeout(() => {
      this.map && this.reSetMarker(lnglat)
    }, 1000)

    const pos = {}
    if (showType === 2) {
      pos.top = 4
    } else if (showType === 1) {
      pos.bottom = 4
    }
    return (
      <div style={{ height: '100%' }}>
        <Cover />
        {address.text && (showType === 1 || showType === 2) && (
          <div style={Object.assign({}, address.style, pos)}>
            {address.text}
          </div>
        )}
        <AMap
          onInit={map => {
            this.map = map
          }}
          style={{ height: '100%' }}
        />
      </div>
    )
  }
}
