import React, { Component } from 'react'
import { Form, Tabs, Row, Col, Input } from 'antd'
import styles from '../edits.less'
import { AddressType as type } from 'wp/utils/itemType'
import Editor from 'wp/constructors/editor/index'
import { observer, inject } from 'mobx-react'
import AMap from 'pro/components/amap'
import addressStyles from './index.less'

const TabPane = Tabs.TabPane

@Editor({
  type
})
@inject('WPSceneStore')
@observer
export default class AddressEditor extends Component {
  reSetMarker = lnglat => {
    if (!lnglat) return
    this.marker && this.marker.setMap(null)
    this.marker = new window.AMap.Marker({
      icon: 'https://webapi.amap.com/theme/v1.3/markers/n/mark_b.png',
      position: lnglat
    })
    this.marker.setMap(this.map)
    this.map.setZoomAndCenter(14, lnglat)
    this.lnglat = lnglat
  }
  render() {
    const { target, BasicAttrsCom, WidgetNameCom, handleChange } = this.props
    const { address, lnglat } = target
    const { showType } = address
    this.map && this.reSetMarker(lnglat)
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="地址" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  地址
                </Col>
              </Row>
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  <div className={addressStyles['fastStyles']}>
                    <div
                      onClick={() => {
                        handleChange({ 'address.showType': 2 })
                      }}
                      className={showType === 2 ? addressStyles['active'] : ''}
                    >
                      <img src="//yun.tuia.cn/tuia/jimo-web-pro/addressStyle2.png" />
                    </div>
                    <div
                      onClick={() => {
                        handleChange({ 'address.showType': 1 })
                      }}
                      className={showType === 1 ? addressStyles['active'] : ''}
                    >
                      <img src="//yun.tuia.cn/tuia/jimo-web-pro/addressStyle1.png" />
                    </div>
                    <div
                      style={{visibility: 'hidden', pointerEvents: 'none'}}
                      onClick={() => {
                        handleChange({ 'address.showType': 3 })
                      }}
                      className={showType === 3 ? addressStyles['active'] : ''}
                    >
                      <img src="//yun.tuia.cn/tuia/jimo-web-pro/addressStyle3.png" />
                    </div>
                  </div>
                </Col>
              </Row>
              <Row style={{ marginBottom: 12 }}>
                <Col offset={1} span={22}>
                  <Input
                    id="amap-input"
                    value={address.text}
                    placeholder="请输入地址"
                    autoComplete="off"
                    style={{ marginBottom: 12 }}
                    onChange={e => handleChange({
                      'address.text': e.target.value
                    })}
                  />
                  <AMap
                    onInit={map => {
                      this.map = map
                      this.map && this.reSetMarker(lnglat)
                      // 输入提示
                      var auto = new window.AMap.Autocomplete({
                        input: 'amap-input'
                      })
                      // 构造地点查询类
                      window.AMap.event.addListener(auto, 'select', e => {
                        if (e.poi.location) {
                          const { lng, lat } = e.poi.location
                          handleChange({
                            'address.text': e.poi.name,
                            lnglat: [lng, lat]
                          })
                        }
                      })
                    }}
                    style={{ height: 220 }}
                  />
                </Col>
              </Row>
              {BasicAttrsCom}
            </Form>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
