import React, { Component } from 'react'
import styles from '../index.less'
import widgetsStyle from 'wp/widgets/widgets.less'
import { inject, observer } from 'mobx-react'
import { DropTarget } from 'react-dnd'
import * as types from 'wp/utils/itemType'
import Widgets from 'wp/widgets/allWidgets'
import { sceneUniqueId } from 'wp/config'
import Popup from 'wp/widgets/popup/backend'
import { TriggerableGuide } from 'wp/features/guide'
import { WidgetContextGuider } from 'wp/guides'
import { STAGE } from 'wp/utils/sceneType'
import store from 'wp/store'

const typeArr = Object.keys(types).map(key => types[key])

const DropSpecEvents = {
  drop(props, monitor, component) {
    const DropContainerRect = document
      .getElementById(sceneUniqueId)
      .getBoundingClientRect()
    // 拖拽end时pointer坐标
    const pointerCoords = monitor.getClientOffset()
    const coordRelScene = {
      x: pointerCoords.x - DropContainerRect.x,
      y: pointerCoords.y - DropContainerRect.y
    }
    return {
      dropped: true,
      coordRelScene,
      sceneType: STAGE
    }
  },
  hover(props, monitor, component) {
    // console.log(props, monitor, component);
  },
  canDrop(props, monitor) {
    const {
      WPPopupStore: { showingPopupId }
    } = props
    // 无弹层显示且场景为STAGE时，可拖拽
    return store.WPSwitch.currentScene === STAGE && !showingPopupId
  }
}

const collecting = (connect, monitor) => ({
  connectDropTarget: connect.dropTarget(),
  isOver: monitor.isOver(),
  canDrop: monitor.canDrop(),
  draggingColor: monitor.getItemType()
})

@inject('WPSceneStore')
@inject('WPPopupStore')
@DropTarget(typeArr, DropSpecEvents, collecting)
@observer
export default class SceneInner extends Component {
  componentWillReact = () => {
    const { itemList } = this.props.WPSceneStore
    if (
      itemList.filter(item => item.widgetType !== types.PopupType).length === 2
    ) {
      TriggerableGuide.show({
        id: sceneUniqueId,
        theme: 'normal',
        placement: 'right',
        domId: sceneUniqueId,
        infinity: false,
        text: WidgetContextGuider,
        introOffset: {
          left: 20,
          top: 0
        }
      })
    }
  }
  componentDidMount() {
    // 初始化场景
    store.WPSwitch.switchScene(STAGE)
  }
  render() {
    const { connectDropTarget, style } = this.props

    return connectDropTarget(
      <div
        className={`${styles['scene-inner']} ${widgetsStyle['widgets-wrapper']}`}
        style={style}
        id={sceneUniqueId}
      >
        <Popup />
        {this.props.WPSceneStore.itemList.map((item, idx) => {
          const SpecWidget = Widgets[item.widgetType]
          return <SpecWidget key={idx} {...item} />
        })}
      </div>
    )
  }
}
