import React, { Component } from 'react'
import Inner from './inner'
import styles from '../index.less'
import { inject, observer } from 'mobx-react'
import { bodySizes, sceneUniqueId } from 'wp/config'
import ResizerY from './resizerY'
import Addons from './addons'
import store from 'wp/store'
import { getNumber } from 'wp/utils/helper'

const minHeight = bodySizes.sceneContainer.inner.minHeight
const initWidth = bodySizes.sceneContainer.inner.initWidth
const initHeight = bodySizes.sceneContainer.inner.initHeight

@inject('WPSceneStore')
@observer
export default class Scene extends Component {
  constructor(props) {
    super(props)
    this.state = {
      stageHeight: initHeight,
      stageWidth: initWidth
    }
  }
  handleMouseMove(e) {
    e.preventDefault()
    typeof window.__widgetMouseMove__ === 'function' &&
      window.__widgetMouseMove__(e.clientX, e.clientY)
    typeof window.__widgetResizerMouseMove__ === 'function' &&
      window.__widgetResizerMouseMove__(e)
  }
  handleMouseUp = e => {
    if (typeof window.__widgetMouseUp__ === 'function') {
      window.__widgetMouseUp__(e.clientX, e.clientY)
    } else if (typeof window.__widgetResizerMouseMUp__ === 'function') {
      window.__widgetResizerMouseMUp__(e)
    } else {
      if (e.target.id === sceneUniqueId) {
        store.WPSceneStore.chooseTarget({ targetId: '' })
      }
    }
  }
  onResizingY = value => {
    this.setState({
      stageHeight: value
    })
  }
  componentDidMount = () => {
    this.remove1 = store.WPHookStore.addHook(
      'onSceneInnerWidthChangeEnd',
      ({ width }) => {
        this.setState({
          stageWidth: width
        })
      }
    )
    this.remove2 = store.WPHookStore.addHook('onInit', ({ page }) => {
      const { height, width } = page
      this.setState({
        stageHeight: getNumber(height),
        stageWidth: getNumber(width)
      })
    })
    this.remove3 = store.WPHookStore.addHook(
      'onSceneInnerHeightChangeEnd',
      ({ height }) => {
        this.setState({
          stageHeight: height
        })
      }
    )
  }
  componentWillUnmount() {
    this.remove1 && this.remove1()
    this.remove2 && this.remove2()
    this.remove3 && this.remove3()
  }
  handleClick(e) {
    if (e.target.id === '__scene-container__') {
      store.WPSceneStore.chooseTarget({ targetId: '' })
    }
  }
  render() {
    const {
      title,
      backgroundImage,
      backgroundColor,
      backgroundRepeat,
      backgroundSize,
      backgroundPosition
    } = this.props.WPSceneStore.scene
    return (
      <div
        id="__scene-container__"
        className={styles['scene-container']}
        style={bodySizes.sceneContainer}
        onClick={this.handleClick}
        onMouseMoveCapture={this.handleMouseMove}
        onMouseUp={this.handleMouseUp}
      >
        {/* // TODO 后期可定义多个wrapper也就说同时编辑多页面 */}
        <div
          className={styles['wrapper']}
          style={{ width: this.state.stageWidth + 20 }}
        >
          <div className={styles['title']}>{title}</div>
          <div className={styles['border']} />
          <Inner
            style={{
              width: this.state.stageWidth,
              minHeight: minHeight,
              height: this.state.stageHeight || 0,
              backgroundImage,
              backgroundColor,
              backgroundRepeat,
              backgroundSize,
              backgroundPosition
            }}
          />
          <div className={styles['addons']}>
            <Addons />
          </div>
          <ResizerY
            stageWidth={this.state.stageWidth}
            onChanging={this.onResizingY}
          />
        </div>
      </div>
    )
  }
}
