import React, { Component } from 'react'
import ItemsStyle from 'wp/widgets/items.less'
import Items from 'wp/widgets/allItems'
import classify from './classify'
import { inject, observer } from 'mobx-react'
import { sceneEnableTypesMapping } from 'wp/utils/sceneType'
@inject('WPSwitch')
@observer
export default class ItemsTab extends Component {
  render() {
    const { currentScene } = this.props.WPSwitch
    return (
      <React.Fragment>
        {classify.map((item, index) => {
          return (
            <div key={index}>
              <div className={ItemsStyle.title}>{item.title}</div>
              <div className={ItemsStyle.items}>
                {Object.keys(Items)
                  .filter(
                    type =>
                      item.types.indexOf(type) !== -1 &&
                      sceneEnableTypesMapping[currentScene].indexOf(type) > -1
                  )
                  .map((key, idx) => {
                    const ItemCom = Items[key]
                    return <ItemCom key={idx} />
                  })}
              </div>
            </div>
          )
        })}
      </React.Fragment>
    )
  }
}
