import React from 'react'
import ReactCSS from 'reactcss'
import styles from '../index.less'
import cn from 'classnames'

const arrow = {
  width: 12,
  height: 8
}

export default function Intro({ cancel, config }) {
  if (!config) return <div />
  let { domId, text, introOffset, placement, arrowOffset } = config
  // 传组件
  const Text = text
  // 兼容undefined
  if (!arrowOffset) arrowOffset = {}
  if (!introOffset) introOffset = {}
  let boundingRect = document.getElementById(domId).getBoundingClientRect()
  let domRect = {}
  ;['width', 'height', 'top', 'bottom', 'left', 'right'].forEach(key => (domRect[key] = boundingRect[key]))
  // 转换bottom,right值为css中的bottom,right
  domRect.bottom = window.innerHeight - domRect.bottom
  domRect.right = window.innerWidth - domRect.right
  // 引导框位置
  const wrapperPos = {}
  // 箭头样式
  const arrowStyle = {}
  // 箭头方向
  let arrowDirection = ''
  switch (placement) {
    default:
    case 'right':
      wrapperPos.left = domRect.left + domRect.width + (introOffset.left || 0) + 'px'
      wrapperPos.top = domRect.top + domRect.height / 2 + (introOffset.top || 0) + 'px'
      wrapperPos.transform = 'translateY(-50%)'
      // 箭头位置
      arrowStyle.left = domRect.left + domRect.width - arrow.height + (introOffset.left || 0) + 'px'
      arrowStyle.top = boundingRect.top + boundingRect.height / 2 - arrow.width / 2 + (arrowOffset.top || 0) + 'px'
      arrowStyle.borderRightColor = '#fff'
      arrowDirection = 'left'
      break
    case 'left':
      wrapperPos.right = domRect.right + domRect.width + arrow.height + (introOffset.right || 0) + 'px'
      wrapperPos.top = domRect.top + domRect.height / 2 + (introOffset.top || 0) + 'px'
      wrapperPos.transform = 'translateY(-50%)'
      // 箭头位置
      arrowStyle.right = domRect.right + domRect.width + (introOffset.right || 0) + 'px'
      arrowStyle.top = boundingRect.top + boundingRect.height / 2 - arrow.width / 2 + (arrowOffset.top || 0) + 'px'
      arrowStyle.borderLeftColor = '#fff'
      arrowDirection = 'right'
      break
    case 'bottom':
      wrapperPos.left = domRect.left + domRect.width / 2 + (introOffset.left || 0) + 'px'
      wrapperPos.top = domRect.top + domRect.height + (introOffset.top || 0) + 'px'
      wrapperPos.transform = 'translateX(-50%)'
      // 箭头位置
      arrowStyle.left = boundingRect.left + boundingRect.width / 2 - arrow.width / 2 + (arrowOffset.left || 0) + 'px'
      arrowStyle.top = boundingRect.bottom + (introOffset.top || 0) - arrow.height + 'px'
      arrowStyle.borderBottomColor = '#fff'
      arrowDirection = 'top'
      break
    case 'top':
      wrapperPos.left = domRect.left + domRect.width / 2 + (introOffset.left || 0) + 'px'
      wrapperPos.bottom = domRect.bottom + domRect.height + (introOffset.bottom || 0) + 'px'
      wrapperPos.transform = 'translateX(-50%)'
      // 箭头位置
      arrowStyle.left = boundingRect.left + boundingRect.width / 2 - arrow.width / 2 + (arrowOffset.left || 0) + 'px'
      arrowStyle.bottom = domRect.bottom + domRect.height + (introOffset.bottom || 0) - arrow.height + 'px'
      arrowStyle.borderTopColor = '#fff'
      arrowDirection = 'down'
      break
  }
  const IntroStyles = ReactCSS({
    default: {
      'guide-intro-wrapper': {
        position: 'absolute',
        backgroundColor: '#fff',
        boxShadow: '0px 2px 10px 0px rgba(87, 140, 254, 0.4)',
        borderRadius: '4px',
        ...wrapperPos,
        transition: 'all 1s ease-in-out'
      },
      'guide-intro-arrow': {
        position: 'absolute',
        transition: 'all 1s ease-in-out',
        ...arrowStyle
      }
    }
  })
  return (
    <React.Fragment>
      <div className="fadeIn animated" style={IntroStyles['guide-intro-wrapper']}>
        <Text cancel={cancel} />
      </div>
      <div className={cn(styles[`triangle-${arrowDirection}`])} style={IntroStyles['guide-intro-arrow']} />
    </React.Fragment>
  )
}
