import React, { Component } from 'react'
import ReactCSS from 'reactcss'
import styles from '../index.less'
import cn from 'classnames'

const arrow = {
  width: 12,
  height: 8
}

export default class Intro extends Component {
  render() {
    const { config, index } = this.props
    if (config.mode !== 'step') return
    const child = config.steps[index]
    // 如果是step模式得确保child存在
    if (!child) return <div />
    // 最后一个？
    const isLast = index === config.steps.length - 1
    let { domSelector, src, text, introOffset, placement, arrowOffset } = child
    // 兼容undefined
    if (!arrowOffset) arrowOffset = {}
    if (!introOffset) introOffset = {}
    let boundingRect = document.querySelector(domSelector).getBoundingClientRect()
    let domRect = {}
    ;['width', 'height', 'top', 'bottom', 'left', 'right'].forEach(key => (domRect[key] = boundingRect[key]))
    // 转换bottom,right值为css中的bottom,right
    domRect.bottom = window.innerHeight - domRect.bottom
    domRect.right = window.innerWidth - domRect.right
    const btnCommonStyle = {
      lineHeight: '32px',
      fontSize: '14px',
      cursor: 'pointer',
      userSelect: 'none'
    }
    // 引导框位置
    const wrapperPos = {}
    // 箭头样式
    const arrowStyle = {}
    // 箭头方向
    let arrowDirection = ''
    switch (placement) {
      default:
      case 'right':
        wrapperPos.left = domRect.left + domRect.width + (introOffset.left || 0) + 'px'
        wrapperPos.top = domRect.top + (introOffset.top || 0) + 'px'
        // 箭头位置
        arrowStyle.left = domRect.left + domRect.width - arrow.height + (introOffset.left || 0) + 'px'
        arrowStyle.top = boundingRect.top - arrow.width / 2 + (arrowOffset.top || 0) + 'px'
        arrowStyle.borderRightColor = '#fff'
        arrowDirection = 'left'
        break
      case 'left':
        // wrapperPos.right = domRect.right + domRect.width + introOffset.right || 0
        // 为了配合使用css过渡动画
        wrapperPos.left = window.innerWidth - (domRect.right + domRect.width + introOffset.right || 0) - 514 + 'px'
        wrapperPos.top = domRect.top + (introOffset.top || 0) + 'px'
        // 箭头位置
        // arrowStyle.right = domRect.right + domRect.width - arrow.height + introOffset.right || 0 + 'px'
        // 为了配合使用css过渡动画
        arrowStyle.left = window.innerWidth - (domRect.right + domRect.width - arrow.height + introOffset.right || 0) - arrow.height + 'px'
        arrowStyle.top = boundingRect.top - arrow.width / 2 + (arrowOffset.top || 0) + 'px'
        arrowStyle.borderLeftColor = '#fff'
        arrowDirection = 'right'
        break
      case 'bottom':
        wrapperPos.left = domRect.left + (introOffset.left || 0) + 'px'
        wrapperPos.top = domRect.top + domRect.height + (introOffset.top || 0) + 'px'
        // 箭头位置
        arrowStyle.left = boundingRect.left + boundingRect.width / 2 - arrow.width / 2 + (arrowOffset.left || 0) + 'px'
        arrowStyle.top = boundingRect.bottom + (introOffset.top || 0) - arrow.height + 'px'
        arrowStyle.borderBottomColor = '#fff'
        arrowDirection = 'top'
        break
    }
    const IntroStyles = ReactCSS({
      default: {
        'guide-intro-wrapper': {
          position: 'absolute',
          width: '514px',
          height: '273px',
          padding: '20px 23px',
          backgroundColor: '#fff',
          boxShadow: '0px 2px 10px 0px rgba(87, 140, 254, 0.4)',
          borderRadius: '4px',
          ...wrapperPos,
          display: 'flex',
          transition: 'all 1s ease-in-out'
        },
        'guide-intro-img': {
          backgroundImage: `url("${src}")`,
          width: '233px',
          height: '233px',
          backgroundSize: '100% 100%'
        },
        'guide-intro-inner-wrapper': {
          flex: 1,
          display: 'flex',
          flexDirection: 'column',
          paddingLeft: '24px'
        },
        'guide-intro-inner': {
          flex: 1,
          overflow: 'auto'
        },
        'guide-intro-btns': {
          height: '32px',
          display: 'flex',
          justifyContent: 'flex-end'
        },
        'guide-intro-btns-cancel': {
          ...btnCommonStyle,
          color: '#999999'
        },
        'guide-intro-btns-confirm': {
          ...btnCommonStyle,
          color: '#2D9AFF',
          marginLeft: '30px'
        },
        'guide-intro-arrow': {
          position: 'absolute',
          transition: 'all 1s ease-in-out',
          ...arrowStyle
        }
      }
    })
    return (
      <React.Fragment>
        <div className="fadeInDown animated" style={IntroStyles['guide-intro-wrapper']}>
          <div style={IntroStyles['guide-intro-img']} />
          <div style={IntroStyles['guide-intro-inner-wrapper']}>
            <div style={IntroStyles['guide-intro-inner']}>{text}</div>
            <div style={IntroStyles['guide-intro-btns']}>
              {!isLast && (
                <div style={IntroStyles['guide-intro-btns-cancel']} onClick={this.props.cancel}>
                  跳过
                </div>
              )}
              <div style={IntroStyles['guide-intro-btns-confirm']} onClick={this.props.next}>
                {isLast ? '知道了' : '继续查看'}
              </div>
            </div>
          </div>
        </div>
        <div className={cn(styles[`triangle-${arrowDirection}`])} style={IntroStyles['guide-intro-arrow']} />
      </React.Fragment>
    )
  }
}
