import React, { Component } from 'react'
import { VerticalIndicator, HorizontalIndicator } from '../fc/indicator'
import Styles from './index.less'

export default class Indicator extends Component {
  render () {
    const { vt, vm, vb, hl, hc, hr } = this.props
    return (
      <React.Fragment>
        <div className={Styles.indicatorV} style={this.props.style}>
          <VerticalIndicator {...{ top: 0, ...generateProps(vt) }} />
          <VerticalIndicator {...{ top: '50%', transform: 'translateY(-50%)', ...generateProps(vm) }} />
          <VerticalIndicator {...{ bottom: 0, ...generateProps(vb) }} />
        </div>
        <div className={Styles.indicatorH} style={this.props.style}>
          <HorizontalIndicator {...{ left: 0, ...generateProps(hl) }} />
          <HorizontalIndicator {...{ left: '50%', transform: 'translateX(-50%)', ...generateProps(hc) }} />
          <HorizontalIndicator {...{ right: 0, ...generateProps(hr) }} />
        </div>
      </React.Fragment>
    )
  }
}

// visible hidden(or undefined)
function generateProps (type) {
  if (type === 'visible') {
    return { display: 'block' }
  } else {
    return { display: 'none' }
  }
};
