/* disable-eslint */
import React, { Component } from 'react'
import styles from './index.less'
import Resizer from './resizer'
import Indicator from './indicator'
import Hoverment from './hover'
import { inject, observer } from 'mobx-react'
import { action } from 'mobx'
import { unset, pick } from 'lodash-es'
import { stopPropagation, getNumber, deepClone } from 'wp/utils/helper'
import { Dropdown, Menu } from 'antd'
import { draggingInScene, sceneUniqueId } from 'wp/config'
import store from 'wp/store'
import sceneMapping from 'wp/utils/sceneType'
// import Utils from 'pro/lib/utils'

const menuItemStyle = {
  display: 'flex',
  justifyContent: 'space-between'
}

export default function widgetWrapper({
  resizer,
  mover = {
    top: true,
    left: true
  },
  block,
  onWidgetMount = () => {},
  onWidgetWillUnmount = () => {}
} = {}) {
  return function WidgetDecorator(Inner) {
    @inject('WPSceneStore')
    @observer
    class Widget extends Component {
      mover = mover
      state = {
        mouseStartPos: {
          x: NaN,
          y: NaN
        },
        targetStartPos: {
          x: NaN,
          y: NaN
        },
        targetPos: {
          left: NaN,
          top: NaN
        },
        _target: {
          width: NaN,
          height: NaN,
          transform: '',
          opacity: NaN,
          zIndex: NaN
        },
        // 这里借用React做Dom渲染
        isDraggingInScene: false,
        indicator: {},
        // hover效果
        hover: false
      }
      getCurrentSceneStore = () => {
        return store[sceneMapping[store.WPSwitch.currentScene]]
      }
      handleClick = e => {
        const { targetId } = this.props
        const curStore = this.getCurrentSceneStore()
        // 检查当前组件是否为当前场景中的组件
        if (
          curStore.itemList.findIndex(item => item.targetId === targetId) > -1
        ) {
          action(this.getCurrentSceneStore().chooseTarget)({
            targetId
          })
        }
      }
      handleMouseEnter = () => {
        this.setState({
          hover: true
        })
      }
      handleMouseOut = () => {
        this.setState({
          hover: false
        })
      }
      handleMouseDown = e => {
        this.handleClick(e)
        this.handleMouseOut()
        if (
          this.getCurrentSceneStore().editingTarget.id !== this.props.targetId
        ) {
          return
        }
        stopPropagation(e)
        // 初始化拖拽信息
        const widgetDom = document.querySelector(`[wid="${this.state.uuid}"`)
        this.setState({
          mouseStartPos: {
            x: e.clientX,
            y: e.clientY
          },
          targetStartPos: {
            x: getNumber(widgetDom.style.left),
            y: getNumber(widgetDom.style.top)
          }
        })
        // 使能mousemove与mouseup
        window.__widgetMouseMove__ = this.__handleMouseMove__
        window.__widgetMouseUp__ = this.__handleMouseUp__
      }
      __handleMouseMove__ = (x, y) => {
        // !更新该组件位置（调用频次很高，注意性能）
        // console.time('计算拖动所需时间')
        const widgetDom = document.querySelector(`[wid="${this.state.uuid}"`)
        const left =
          this.state.targetStartPos.x + (x - this.state.mouseStartPos.x)
        const top =
          this.state.targetStartPos.y + (y - this.state.mouseStartPos.y)

        // 修改组件拖动状态为true（优化后）
        if (!this.state.isDraggingInScene) {
          this.setState({
            isDraggingInScene: true
          })
        }
        // 水平偏差量
        const HDeviation = draggingInScene.HorizontalDeviation
        // 场景当前宽
        const sceneWidth = getNumber(
          window.getComputedStyle(document.getElementById(sceneUniqueId)).width
        )
        // widget属性
        const widgetWidth = getNumber(widgetDom.style.width)
        const widgetLeft = left
        // 距离舞台中心线偏移距离
        const offsetDis = sceneWidth / 2 - (widgetWidth / 2 + widgetLeft)
        // 是否几乎居中
        const isAlmostHorizontalCenter = Math.abs(offsetDis) < HDeviation
        // 是否几乎居左
        const isAlmostHorizontalLeft = Math.abs(widgetLeft) < HDeviation
        // 是否几乎居右
        const isAlmostHorizontalRight =
          Math.abs(sceneWidth - widgetWidth - widgetLeft) < HDeviation
        // 居中此div实际需要的left值
        const centerLeft = (sceneWidth - widgetWidth) / 2
        // 居左此div实际需要的left值
        const startLeft = 0
        // 居右此div实际需要的left值
        const endLeft = centerLeft * 2

        // 修改实际dom left值
        if (mover.left) {
          widgetDom.style.left =
            (isAlmostHorizontalCenter
              ? centerLeft
              : isAlmostHorizontalLeft
                ? startLeft
                : isAlmostHorizontalRight
                  ? endLeft
                  : widgetLeft) + 'px'
        }

        // 垂直偏差量
        const VDeviation = draggingInScene.VerticalDeviation
        // 场景当前高
        const sceneHeight = getNumber(
          window.getComputedStyle(document.getElementById(sceneUniqueId)).height
        )
        // widget属性
        const widgetHeight = getNumber(widgetDom.style.height)
        const widgetTop = top
        // 距离舞台中心偏移距离
        const offsetDisY = sceneHeight / 2 - (widgetHeight / 2 + widgetTop)
        // 是否几乎居中
        const isAlmostVerticalCenter = Math.abs(offsetDisY) < VDeviation
        // 是否几乎居顶
        const isAlmostVerticalTop = Math.abs(widgetTop) < VDeviation
        // 是否几乎居底
        const isAlmostVerticalBottom =
          Math.abs(sceneHeight - widgetHeight - widgetTop) < VDeviation
        // 居中此div实际需要的top值
        const centerTop = (sceneHeight - widgetHeight) / 2
        // 居顶此div实际需要的top值
        const startTop = 0
        // 居底此div实际需要的top值
        const endTop = centerTop * 2

        // 修改实际dom top值
        if (mover.top) {
          widgetDom.style.top =
            (isAlmostVerticalCenter
              ? centerTop
              : isAlmostVerticalTop
                ? startTop
                : isAlmostVerticalBottom
                  ? endTop
                  : widgetTop) + 'px'
        }

        // 显示对应Indicator
        const showIndicatorX = isAlmostHorizontalCenter
          ? 'hc'
          : isAlmostHorizontalLeft
            ? 'hl'
            : isAlmostHorizontalRight
              ? 'hr'
              : ''
        const showIndicatorY = isAlmostVerticalCenter
          ? 'vm'
          : isAlmostVerticalTop
            ? 'vt'
            : isAlmostVerticalBottom
              ? 'vb'
              : ''
        if (showIndicatorX || showIndicatorY) {
          const { hc, hl, hr, vm, vt, vb } = this.state.indicator
          if ((!hc || !hl || !hr) && (!vm || !vt || !vb)) {
            let indicator = {}
            mover.left &&
              showIndicatorX &&
              (indicator[showIndicatorX] = 'visible')
            mover.top &&
              showIndicatorY &&
              (indicator[showIndicatorY] = 'visible')
            this.setState({ indicator })
          }
        } else {
          if (this.state.indicator) {
            this.setState({
              indicator: {}
            })
          }
        }
        // console.timeEnd('计算拖动所需时间')
      }
      __handleMouseUp__ = e => {
        const dpr = 1
        const widgetDom = document.querySelector(`[wid="${this.state.uuid}"`)
        const left = dpr * getNumber(widgetDom.style.left) + 'px'
        const top = dpr * getNumber(widgetDom.style.top) + 'px'
        let updated = {}
        if (mover.top) updated['style.top'] = top
        if (mover.left) updated['style.left'] = left
        // 更新store
        action(this.getCurrentSceneStore().changeItemProps)(updated)
        // 删除mousemove与mouseup，释放内存
        window.__widgetMouseMove__ = null
        window.__widgetMouseUp__ = null
        // 修改组件拖动状态为false
        this.setState({
          isDraggingInScene: false
        })
      }
      handleReszie = ({ width, height, left, top, deg }) => {
        const widgetDom = document.querySelector(`[wid="${this.state.uuid}"`)

        widgetDom.style.left = left + 'px'
        widgetDom.style.top = top + 'px'
        widgetDom.style.width = width + 'px'
        widgetDom.style.height = height + 'px'
        widgetDom.style.transform = `rotate(${deg}deg)`
      }
      hanldeReszieComplete = ({ width, height, left, top, deg }) => {
        const dpr = 1
        action(this.getCurrentSceneStore().changeItemProps)({
          'style.width': width * dpr + 'px',
          'style.height': height * dpr + 'px',
          'style.left': left * dpr + 'px',
          'style.top': top * dpr + 'px',
          'style.transform': `rotate(${deg}deg)`
        })
      }
      componentWillUnmount = () => {
        // onWidgetWillUnmount生命周期
        Promise.resolve({ targetId: this.props.targetId }).then(
          onWidgetWillUnmount
        )

        // 注销监听onSceneKeydown事件
        this.onSceneKeydownRemover && this.onSceneKeydownRemover()

        // 注销监听onSceneKeyup事件
        this.onSceneKeyupRemover && this.onSceneKeyupRemover()
      }
      componentDidMount = () => {
        const { targetId } = this.props
        this.setState({ uuid: targetId })
        // onWidgetMount生命周期
        Promise.resolve({ targetId }).then(onWidgetMount)

        // let closure = (() => {
        //   // 双组合键支持
        //   let pressingKey = 0
        //   let isThisWidget = () => store.WPSceneStore.editingTarget.id === this.props.targetId
        //   return {
        //     keyupHandler: ({ e }) => {
        //       if (!isThisWidget()) return false
        //       const keyCode = e.keyCode
        //       // Delete/Backspace
        //       if (keyCode === 8 || keyCode === 46) {
        //         // this.delete()
        //       }
        //       if (Utils.isMac || Utils.isWin) {
        //         // Ctrl + c键
        //         if (keyCode === 67 && e.ctrlKey) {
        //           this.copyAndPaste()
        //         }
        //       }
        //       // 暂无法实现
        //       if (Utils.isMac) {
        //         // Meta + c键
        //         if (pressingKey === 91 && keyCode === 67) {
        //           this.copyAndPaste()
        //           pressingKey = 0
        //         } else {
        //           pressingKey = keyCode
        //         }
        //       }
        //       // reset pressingKey
        //       pressingKey = 0
        //     }
        //   }
        // })()

        // // 监听scene keyup 事件
        // this.onSceneKeyupRemover = store.WPHookStore.addHook('onSceneKeyup', closure.keyupHandler)
      }
      // 上移下移
      changeLayer = type => {
        const { zIndex } = this.props[this.props.widgetType].style
        const { changeItemProps } = this.getCurrentSceneStore()
        if (type === 'up') {
          changeItemProps({
            'style.zIndex': zIndex + 1
          })
        } else if (type === 'down') {
          changeItemProps({
            'style.zIndex': zIndex - 1
          })
        }
      }
      // 复制
      copyAndPaste = () => {
        action(this.getCurrentSceneStore().copyAndPasteItem)(
          this.props.targetId
        )
      }
      // 删除
      delete = () => {
        action(this.getCurrentSceneStore().removeCurrItem)()
      }
      render() {
        // 当前widget唯一id
        const { targetId } = this.props
        // 当前widget类型
        const widgetType = this.props.widgetType
        // 判断当前widget是否选中
        const isThisWidget =
          this.getCurrentSceneStore().editingTarget.id === targetId
        // 判断当前widget是否正在拖拽中
        const isDragging = this.state.isDraggingInScene
        // 场景中组件中zIndex最大值
        // 场景中组件中zIndex最小值
        const { maxZIndex, minZIndex } = this.getCurrentSceneStore().getZIndex()
        const canGoUp =
          maxZIndex === minZIndex
            ? true
            : maxZIndex !== this.props[widgetType].style.zIndex
        const canGoBottom =
          maxZIndex === minZIndex
            ? true
            : minZIndex !== this.props[widgetType].style.zIndex
        // 当前widget所有样式
        const storeStyle = deepClone(this.props[widgetType].style)
        // 过滤widget通用样式
        const style = Object.assign(
          {
            position: 'absolute'
          },
          pick(storeStyle, [
            'left',
            'right',
            'top',
            'width',
            'height',
            'transform',
            'zIndex',
            'display',
            'bottom'
          ])
        )
        // 所有样式转换为原生js对象，同时表示已读取proxy的值
        const attrs = deepClone(this.props[widgetType])

        // 给定width,height,position使得Inner好布局
        attrs.style.width = '100%'
        attrs.style.height = '100%'
        attrs.style.position = 'relative'
        // 卸载掉实际widget组件不能也不应修改的属性
        unset(attrs.style, 'left')
        unset(attrs.style, 'top')
        unset(attrs.style, 'transform')
        unset(attrs.style, 'zIndex')
        unset(attrs.style, 'right')
        unset(attrs.style, 'bottom')
        // 根据fixed字段
        this.mover.top = !attrs.fixed
        this.mover.left = !attrs.fixed
        return (
          <div
            wid={this.state.uuid}
            className={styles['widget-wrapper']}
            style={style}
            onMouseDown={this.handleMouseDown}
            onMouseUp={this.handleMouseUp}
            onMouseEnter={() => !isThisWidget && this.handleMouseEnter()}
            onClick={e => e.stopPropagation()}
          >
            {/* Hover */}
            {!isThisWidget && this.state.hover && (
              <Hoverment onMouseOut={this.handleMouseOut} />
            )}
            {/* Resizer */}
            {isThisWidget && (
              <Resizer
                onReszie={this.handleReszie}
                onReszieComplete={this.hanldeReszieComplete}
                targetStyle={style}
                options={resizer}
              />
            )}
            {/* Indicator */}
            {isThisWidget && isDragging && (
              <Indicator
                style={{
                  transform: `rotate(${-getNumber(storeStyle.transform)}deg)`
                }}
                {...this.state.indicator}
              />
            )}
            {/* 不放置上一层div是因为避antd坑 */}
            <Dropdown
              disabled={!isThisWidget}
              overlay={
                <Menu style={{ fontSize: 12, width: 240 }}>
                  <Menu.Item
                    key="1"
                    onClick={
                      canGoUp ? this.changeLayer.bind(this, 'up') : () => {}
                    }
                  >
                    <div
                      style={Object.assign(
                        {},
                        menuItemStyle,
                        canGoUp ? {} : { color: '#999', cursor: 'not-allowed' }
                      )}
                    >
                      <span>上移一层</span>
                    </div>
                  </Menu.Item>
                  <Menu.Item
                    key="2"
                    onClick={
                      canGoBottom
                        ? this.changeLayer.bind(this, 'down')
                        : () => {}
                    }
                  >
                    <div
                      style={Object.assign(
                        {},
                        menuItemStyle,
                        canGoBottom
                          ? {}
                          : { color: '#999', cursor: 'not-allowed' }
                      )}
                    >
                      <span>下移一层</span>
                    </div>
                  </Menu.Item>
                  <Menu.Item key="3" onClick={this.copyAndPaste}>
                    <div style={menuItemStyle}>
                      <span>复制</span>
                      {/* <span>Ctrl + C</span> */}
                    </div>
                  </Menu.Item>
                  <Menu.Item key="4" onClick={this.delete}>
                    <div style={menuItemStyle}>
                      <span>删除</span>
                      {/* <span>Delete/Backspace</span> */}
                    </div>
                  </Menu.Item>
                </Menu>
              }
              trigger={['contextMenu']}
            >
              <div style={attrs.style}>
                <Inner
                  widgetAttrs={attrs}
                  targetId={this.props.targetId}
                  changeMover={(key, value) => {
                    this.mover[key] = value
                  }}
                />
              </div>
            </Dropdown>
          </div>
        )
      }
    }

    @observer
    class BlockWidget extends Component {
      handleClick = e => {
        e.stopPropagation()
        // 显示当前部件编辑器
        action(this.getCurrentSceneStore().chooseTarget)({
          targetId: this.props.targetId
        })
      }
      getCurrentSceneStore = () => {
        return store[sceneMapping[store.WPSwitch.currentScene]]
      }
      render() {
        // 当前widget类型
        const widgetType = this.props.widgetType
        // 所有样式转换为原生js对象
        const attrs = deepClone(this.props[widgetType])

        // block类型的Widget特有属性
        attrs.style.width = '100%'
        attrs.style.height = '100%'
        attrs.style.position = 'position'
        attrs.style.top = 0
        attrs.style.left = 0
        attrs.style.userSelect = 'none'
        attrs.style.cursor = 'normal'

        return (
          <Inner
            style={attrs.style}
            onSelect={this.handleClick}
            widgetAttrs={attrs}
            targetId={this.props.targetId}
          />
        )
      }
    }
    return block ? BlockWidget : Widget
  }
}
