import React, { Component } from 'react'
import { observer } from 'mobx-react'
import { Input, Icon } from 'antd'

@observer
export default class WidgetName extends Component {
  changeEditing = state => {
    this.setState({
      isEditingName: state
    })
  };

  changeWidgetName = e => {
    this.props.handleChange({ name: e.target.value })
    this.changeEditing(false)
  }

  state = {
    isEditingName: false
  }

  render () {
    // target属性是当前正在被编辑部件，由Editor高阶组件传入
    const { target } = this.props
    return (
      <React.Fragment>
        {this.state.isEditingName > 0 ? (
          <Input
            defaultValue={target.name}
            onPressEnter={this.changeWidgetName}
            onBlur={this.changeWidgetName}
            autoFocus
          />
        ) : (
          <div onClick={() => this.changeEditing(true)} style={{ cursor: 'pointer', color: 'rgba(0, 0, 0, 0.85)' }}>
            {target.name}
            <Icon type='edit' style={{ marginLeft: '8px' }} />
          </div>
        )}
      </React.Fragment>
    )
  }
}
