import React, { Component } from 'react'
import { inject, observer } from 'mobx-react'
import FirstLayer from '../components/firstLayer/index'
import Style from '../index.less'
import { MobxStore } from '../store'
export const mediaTagsContext = React.createContext < MobxStore > {}

@inject('mediaStore')
@observer
export default class Tag extends Component {
  render() {
    const { allTags } = this.props.mediaStore
    return (
      <div className={`mt20 ${Style.bgWhite}`}>
        {allTags &&
          allTags.map(item => {
            return <FirstLayer key={item.id} tag={item} />
          })}
      </div>
    )
  }
}
