import { observable, computed, action } from 'mobx'
import Common from 'pro/lib/common'
export interface MobxStore {
  fetchAdvertTags?: () => void;
}
class Store {
  // 所有标签
  @observable
  allTags = []

  // 下拉框的数据
  @observable
  tagOptions = []
  // 被高亮的标签
  @observable
  highlightTags = []
  // 被单击了的标签
  @observable
  clickedTags = []
  // 进入修改状态的标签
  @observable
  editTags = []
  // 被移动的标签，其父级以及同级信息
  @observable
  resortTags = []
  // 是否是可以调整顺序的状态
  @observable
  sortMode = false
  /**
   *获取所有标签
   *
   * @memberof Store
   */
  @action
  fetchTags = () => {
    Common.newFetch({
      url: '/java/tag/getAllTags'
    }).then(
      action(res => {
        this.allTags = res.data
        const firstLevel = res.data
        const secondLevel = firstLevel.reduce(
          (a, b) => a.concat(b.children || []),
          []
        )
        const thirdLevel = secondLevel.reduce(
          (a, b) => a.concat(b.children || []),
          []
        )

        this.tagOptions = firstLevel.concat(secondLevel, thirdLevel)
      })
    )
  }
  updateTag = (id, val, parentTag): void => {
    Common.newFetch({
      url: '/java/tag/updateTag',
      method: 'post',
      data: {
        id,
        tagName: val,
        parentId: parentTag.id
      }
    }).then(
      action(res => {
        switch (res['code']) {
          case '0':
            Common.handleSuccess('编辑标签成功')
            this.updateEditTags([])
            this.fetchTags()
            break
          default:
            Common.handleError(res['desc'])
        }
      })
    )
  }
  /**
   *根据标签id，高亮对于的标签
   *
   * @memberof Store
   */
  @action
  updateHighlightTags = (tags: number[]): void => {
    this.highlightTags = tags
  }
  @action
  updateClickedTags = (tags: number[]): void => {
    this.clickedTags = tags
  }
  @action
  updateEditTags = (tags: number[]): void => {
    this.clickedTags = []
    this.editTags = tags
  }
  @action
  updateSort = (tags: any[], changedTags: any[]): void => {
    this.allTags = tags
    // this.mediaTags = tags.filter(item => item.mediaUserPortraitTag)
    // this.otherTags = tags.filter(item => !item.mediaUserPortraitTag)
    this.resortTags.push(changedTags)
  }
  @action
  updateSortMode = (flg: boolean) => {
    this.sortMode = flg
    this.clickedTags = []
    this.editTags = []
    this.highlightTags = []
    if (!flg) {
      this.fetchTags()
    }
  }
  saveSort = () => {
    // reverse 再 去重
    // console.log(this.resortTags)
    const ids = this.resortTags
      .reverse()
      .filter(
        (item, idx, arr) => arr.findIndex(unit => unit.id === item.id) === idx
      )
    console.log(
      'Triggered',
      this.resortTags
        .reverse()
        .filter(
          (item, idx, arr) => arr.findIndex(unit => unit.id === item.id) === idx
        )
    )

    Common.newFetch({
      url: '/mediatag/sort',
      method: 'post',
      data: { data: ids }
    }).then(res => {
      res.data && this.updateSortMode(false)
    })
  }
}
export default Store
