import common from 'pro/lib/common'
import { SitePrefix } from 'pro/config'
import { submitForm, getJavaSiteHost } from 'pro/lib/helper'

export const getFormData = params => {
  return common.fetch(`${SitePrefix}/landData/landUserInfo`, params, 'get')
}

export const getBIData = params => {
  return common.fetch(`${SitePrefix}/landData/landStaticData`, params, 'get')
}

export const getBIChartData = params => {
  return common.fetch(`${SitePrefix}/landData/landStaticDataPUV`, params, 'get')
}

export const getSceneData = landId => {
  return common.fetch(`${SitePrefix}/land/query`, { id: landId }, 'get')
}

export const exportBIData = params => {
  submitForm({
    params,
    action: `//${getJavaSiteHost()}/landData/exportLandStaticData`
  })
}

export const exportFormData = params => {
  submitForm({
    params,
    action: `//${getJavaSiteHost()}/landData/exportLandUserInfo`
  })
}
