import React, { Component } from 'react'
import {
  DatePicker,
  Button,
  Form,
  Input,
  Popover,
  Select,
  TreeSelect
} from 'antd'
import styles from './index.less'
import moment from 'moment'
import TuiaIcon from 'wp/constructors/fc/icon'
import JimuInput1 from 'pro/components/jm-input-1'
import NewPage from 'pro/components/new-page'
const { TreeNode } = TreeSelect
const { RangePicker } = DatePicker

const { Option } = Select

class Search extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      states: [
        {
          label: '全部状态',
          value: 0
        },
        {
          label: '未审核',
          value: 1
        },
        {
          label: '审核中',
          value: 2
        },
        {
          label: '审核通过',
          value: 3
        },
        {
          label: '审核拒绝',
          value: 4
        }
      ],
      types: [
        {
          label: '全部类型',
          value: 0
        },
        {
          label: '贷款',
          value: 1
        },
        {
          label: '信用卡',
          value: 2
        },
        {
          label: '保险',
          value: 3
        },
        {
          label: 'p2p',
          value: 4
        }
      ],
      inputValue: '',
      // 当搜索按钮作为独立控件时需要记录
      startDate: '',
      endDate: '',
      // 是否显示展开/收起按钮
      showSearchOpenCloseButton: false,
      // 展开/收起搜索条件，默认隐藏
      showAllSearchOptions: false
    }
    // 记录搜索控件容器用于获取高度判断是否需要显示展开/收起按钮
    this.searchControlsFromRef = React.createRef()
  }

  componentDidMount() {
    const { clientHeight, scrollHeight } = this.searchControlsFromRef.current
    this.setState({
      showSearchOpenCloseButton: scrollHeight > clientHeight
    })
  }

  onTimeChange = (_, dateString) => {
    // 当清除日期选择器数据时dateString中的值会被置为""  此时再做moment操作会返回"Invalid date"
    dateString[1] = dateString[1]
      ? moment(dateString[1])
          .add(1, 'days')
          .format('YYYY-M-D')
      : ''

    // 20200415改版，交互与layer统一，日期修改的数据请求放在搜索按钮中
    this.setState({ startDate: dateString[0], endDate: dateString[1] })
  }

  handleSearch = () => {
    const { startDate, endDate } = this.state
    this.props.form.validateFields((err, values) => {
      if (err) return console.error(err)
      this.props.handleChange({ startDate, endDate, ...values, currentPage: 1 })
    })
  }

  toggleShowAllSearchOptions = () => {
    this.setState(previousState => {
      return {
        showAllSearchOptions: !previousState.showAllSearchOptions
      }
    })
  }
  treeNodeGen() {
    const { tags } = this.props
    const process = tags => {
      return tags.map(tag => {
        return (
          <TreeNode
            value={tag.tagNum}
            title={tag.tagName}
            key={tag.id}
            selectable={tag.tagLevel > 1}
          >
            {tag.children && process(tag.children)}
          </TreeNode>
        )
      })
    }
    return process(tags)
  }
  render() {
    // const { states, types } = this.state
    // const day = 1000 * 60 * 60 * 24

    const {
      inputValue,
      showAllSearchOptions,
      showSearchOpenCloseButton
    } = this.state
    const { getFieldDecorator } = this.props.form

    return (
      <div className={styles['search-wrapper']}>
        <div className={styles['first']}>
          {/* <Select className="__jm_select__" value={condition.state} style={{ width: 120 }} onChange={value => handleChange({ 'state': value })}>
            {states.map((item, index) => {
              return <Option key={index} value={item.value}>{item.label}</Option>
            })}
          </Select>
          <Select className="__jm_select__" value={condition.type} style={{ width: 120 }} onChange={value => handleChange({ 'type': value })}>
            {types.map((item, index) => {
              return <Option key={index} value={item.value}>{item.label}</Option>
            })}
          </Select> */}
          <RangePicker
            style={{ width: 216 }}
            ranges={{
              最近一天: [moment().subtract(1, 'days'), moment()],
              最近七天: [moment().subtract(7, 'days'), moment()],
              最近一月: [moment().subtract(1, 'months'), moment()],
              最近三月: [moment().subtract(3, 'months'), moment()]
            }}
            onChange={this.onTimeChange}
          />
        </div>
        <div className={styles['last']}>
          {/* 20200414改版 搜索条件交互与 layer 中的搜索统一 */}
          <div
            className={`${showAllSearchOptions ? styles['open'] : ''} ${
              styles['search-controls-wrap']
            }`}
            ref={this.searchControlsFromRef}
          >
            <Form layout="inline">
              <Form.Item label="名称">
                {getFieldDecorator('title', { initialValue: '' })(
                  <Input className={styles.input} />
                )}
              </Form.Item>
              <Form.Item label="ID">
                {getFieldDecorator('id', { initialValue: '' })(
                  <Input className={styles.input} />
                )}
              </Form.Item>
              <Form.Item label="用户">
                {getFieldDecorator('userName', { initialValue: '' })(
                  <Input className={styles.input} />
                )}
              </Form.Item>
              <Form.Item label="落地页标签">
                {getFieldDecorator('promoteTag', { initialValue: '' })(
                  <TreeSelect
                    showSearch
                    style={{ minWidth: 120 }}
                    dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
                    placeholder="选择标签"
                    allowClear
                    treeDefaultExpandAll
                    filterTreeNode={(input, node) =>
                      node.props.title
                        .toLowerCase()
                        .indexOf(input.toLowerCase()) >= 0 &&
                      node.props.selectable
                    }
                  >
                    {this.treeNodeGen()}
                  </TreeSelect>
                )}
              </Form.Item>
            </Form>
          </div>
          {/* 展开收起搜索条件的按钮 */}
          {showSearchOpenCloseButton ? (
            <Button
              className={styles['ant-btn-link']}
              onClick={this.toggleShowAllSearchOptions}
            >
              {showAllSearchOptions ? '收起' : '展开'}
            </Button>
          ) : null}
          <Button
            className={styles['new-page']}
            type="primary"
            onClick={this.handleSearch}
          >
            搜索
          </Button>
          <TuiaIcon
            type="icon-nav_list"
            className={`${styles['list-icon']} ${styles['active']}`}
          />
          {/* <TuiaIcon type="icon-nav_card" className={styles['card-icon']} /> */}
          <NewPage
            content={({ show }) => (
              <Button
                className={styles['new-page']}
                type="primary"
                onClick={show}
              >
                新建站点
              </Button>
            )}
          />
          <Popover
            content={
              <div>
                <Button type="primary">
                  <a href="#/tags">标签管理</a>
                </Button>
              </div>
            }
            title={null}
            trigger="click"
            placement="bottomLeft"
          >
            <Button className={styles['ant-btn-link']}>更多</Button>
          </Popover>
        </div>
      </div>
    )
  }
}

export default Form.create()(Search)
