import React from 'react'

import { inject, observer } from 'mobx-react'

import common from 'pro/lib/common'
import utils from 'pro/lib/utils'

import { Layout } from 'antd'

import Breadcrumb from 'pro/components/breadcrumb'

import styles from './index.less'

const { Header: AntdHeader } = Layout

@inject('userStore')
@observer
class Header extends React.Component {
  handleQuit = () => {
    common.fetch('/sso/outLogin').then(res => {
      if (res.success) {
        utils.logout()
      }
    })
  };
  render () {
    const { routes } = this.props
    const { name } = this.props.userStore.userInfo
    return (
      <AntdHeader className={styles.header}>
        <div className={styles.logo} onClick={() => utils.jumpTo('/workplace/home')}>
          推啊奥利奥
        </div>
        <Breadcrumb routes={routes} />
        <div className={styles.user_info_wrap}>
          <span>{name}</span>
          <span onClick={this.handleQuit}>退出</span>
        </div>
      </AntdHeader>
    )
  }
}

export default Header
