'use strict'

import React from 'react'
import { SketchPicker } from 'react-color'
import { Popover } from 'antd'

class ColorPicker extends React.Component {
  state = {
    selectColor: '#ccc',
    visible: false
  }

  handleClick = () => {
    this.setState({ visible: true })
  }

  hide = () => {
    this.setState({
      visible: false
    })
  }

  handleVisibleChange = visible => {
    this.setState({ visible })
  }

  colorChanged = color => {
    const rgba = color.rgb
    this.setState({
      selectColor: `rgba(${rgba.r},${rgba.g},${rgba.b},${rgba.a})`
    })
  }
  handleChange = (color, event) => {
    const rgba = color.rgb
    this.props.onChange(`rgba(${rgba.r},${rgba.g},${rgba.b},${rgba.a})`)
  }
  componentDidMount() {
    this.setState({
      selectColor: this.props.defaultValue || this.props.value
    })
  }

  render() {
    const selectDiv = {
      width: '100%',
      height: '32px',
      border: '1px solid rgba(217, 217, 217, 0.5)',
      borderRadius: 0,
      cursor: 'pointer'
    }
    const { placement } = this.props
    // this.props.size === 'small' && (selectDiv.height = '24px')
    return (
      <Popover
        content={
          <SketchPicker
            width={238}
            color={this.state.selectColor}
            onChangeComplete={this.colorChanged}
            onChange={this.handleChange}
          />
        }
        title={false}
        placement={placement || 'left'}
        trigger="click"
        visible={this.state.visible}
        onVisibleChange={this.handleVisibleChange}
        overlayClassName="color-picker-popover"
      >
        <div
          onClick={this.handleClick}
          style={Object.assign({}, selectDiv, {
            backgroundColor: this.state.selectColor
          })}
        />
      </Popover>
    )
  }
}

export default ColorPicker
