const path = require('path')
const MiniCssExtractPlugin = require('mini-css-extract-plugin')
const HtmlWebpackPlugin = require('html-webpack-plugin')

const getStyle = isDev => {
  const specPath = [
    /node_modules|admin.less|global.less/,
    path.resolve(__dirname, '../client/pages/pro/styles'),
    path.resolve(__dirname, '../client/pages/pro/render/styles'),
    path.resolve(__dirname, '../client/pages/pro/render/entry.less'),
    path.resolve(__dirname, '../render/v1/styles'),
    path.resolve(__dirname, '../render/v1/index.less')
  ]
  const remPath = [/\.rem\./]
  const loader = isDev ? 'style-loader' : MiniCssExtractPlugin.loader
  const cssSourceMap = !!isDev
  const rule = [
    {
      test: /\.(le|c)ss/,
      exclude: specPath.concat(remPath),
      use: [
        {
          loader: loader
        },
        {
          loader:
            'css-loader?sourceMap&modules=true&localIdentName=[local]_[hash:base64:5]'
        },
        {
          loader: 'less-loader',
          options: {
            javascriptEnabled: true,
            sourceMap: isDev
          }
        }
      ]
    },
    {
      test: /\.(le|c)ss/,
      include: specPath,
      exclude: remPath,
      use: [
        {
          loader: loader
        },
        {
          loader: 'css-loader?sourceMap'
        },
        {
          loader: 'less-loader',
          options: {
            javascriptEnabled: true,
            sourceMap: isDev
          }
        }
      ]
    },
    {
      // 手机版CSS处理
      test: /(\.less|\.css)$/,
      include: remPath,
      use: [
        { loader: loader },
        {
          loader:
            'css-loader?sourceMap&modules=true&localIdentName=[local]_[hash:base64:5]'
        },
        {
          loader: 'px2rem-loader',
          options: {
            remUnit: 200
          }
        },
        {
          loader: 'less-loader',
          options: {
            javascriptEnabled: true,
            sourceMap: cssSourceMap
          }
        }
      ]
    }
  ]

  return rule
}

const getEntry = isDev => {
  let entry = {
    // fixme
    pro: ['./client/pages/pro/index.js']
  }

  if (isDev) {
    const DEV_PROJECT = process.env.DEV_PROJECT
    /**
     * 当DEV_PROJECT位某个项目名时，webpack只对该项目进行打包
     * 例如 `DEV_PROJECT=pro npm run dev:client` 只对pro项目进行打包
     */
    if (DEV_PROJECT && entry[DEV_PROJECT]) {
      entry = { [DEV_PROJECT]: entry[DEV_PROJECT] }
    }

    for (var i in entry) {
      entry[i] = entry[i].concat('webpack-hot-middleware/client')
    }
  }

  return entry
}

const HTML_WEBPACK_PLUGINS = {
  pro: {
    alwaysWriteToDisk: true,
    chunks: ['pro-render', 'pro'],
    filename: 'html/pro.html',
    template: path.resolve(__dirname, '../client/pages/pro/index.html')
  }
}

const getHtmlWebpackPlugins = () => {
  const DEV_PROJECT = process.env.DEV_PROJECT

  /**
   * 当DEV_PROJECT位某个项目名时，webpack只对该项目进行打包
   * 例如 `DEV_PROJECT=pro npm run dev:client` 只对pro项目进行打包
   */
  if (DEV_PROJECT && HTML_WEBPACK_PLUGINS[DEV_PROJECT]) {
    return [new HtmlWebpackPlugin(HTML_WEBPACK_PLUGINS[DEV_PROJECT])]
  } else {
    return Object.values(HTML_WEBPACK_PLUGINS).map(htmlWebpackPluginConfig => {
      return new HtmlWebpackPlugin(htmlWebpackPluginConfig)
    })
  }
}

module.exports = {
  getEntry,
  getStyle,
  getHtmlWebpackPlugins
}
