const webpack = require('webpack')
const merge = require('webpack-merge')
const webpackBaseConfig = require('./webpack.base.js')
const MiniCssExtractPlugin = require('mini-css-extract-plugin')
const ProgressBarPlugin = require('progress-bar-webpack-plugin')
const chalk = require('chalk')
const { getEntry, getStyle } = require('./webpack.util')

module.exports = merge(webpackBaseConfig, {
  mode: 'production',
  entry: getEntry(),
  module: {
    rules: [].concat(getStyle())
  },
  optimization: {
    // minimize: false,
    splitChunks: false
  },
  output: {
    publicPath: '//yun.tuisnake.com/jimu-web/',
    filename: 'assets/[contenthash:8].[name].js',
    chunkFilename: 'assets/[contenthash:8].[name].js'
  },
  plugins: [
    new MiniCssExtractPlugin({
      filename: 'assets/[contenthash:8].[name].css',
      chunkFilename: 'assets/[contenthash:8].[name].css'
    }),
    new webpack.DefinePlugin({
      'process.env': {
        JIMU_ENV: `'${process.env.NODE_ENV}'`
      }
    }),
    new ProgressBarPlugin({
      format: chalk.yellow(
        '打包中 [:bar] :current/:total :percent :elapseds :msg'
      ),
      complete: '●',
      incomplete: '○',
      width: 20
    })
  ]
})
