const express = require('express')
const webpack = require('webpack')
const webpackDevMiddleware = require('webpack-dev-middleware')
const webpackHotMiddleware = require('webpack-hot-middleware')
const path = require('path')
const fs = require('fs')

const app = express()
const config = require('./webpack.dev.js')
const compiler = webpack(config)
const instance = webpackDevMiddleware(compiler, {
  publicPath: config.output.publicPath
})

app.use(instance)
instance.waitUntilValid(() => {
  require('opn')('http://localhost:3010/pro#/home', {
    app: ['google chrome', '--incognito']
  })
})
app.use(webpackHotMiddleware(compiler))

// 加载模板引擎
app.set('views', path.join(__dirname, '../dist/html'))
app.engine('.html', require('ejs').__express)
app.set('view engine', 'html')

app.use('/pro', function(req, res) {
  res.sendFile(path.resolve(__dirname, '../dist/html/pro.html'))
})

app.use(
  express.static('./', {
    extensions: ['html']
  })
)

// 本地mock数据
app.use((req, res) => {
  const path = req.path
  res.set('Content-Type', 'application/json')

  console.log(path)
  try {
    /* eslint no-path-concat: "off" */
    res.send(fs.readFileSync(__dirname + '/../mock' + path + '.json'))
  } catch (e) {
    res.send(
      JSON.stringify({
        code: '0',
        desc: '无此mock数据',
        data: {}
      })
    )
  }
})

const port = 3010
app.listen(port, function() {
  console.log(`Example app listening on http://localhost:${port}!\n`)
})
