import cn from 'classnames'
import toast from '../../libs/toast'
import styles from './index.less'
import Modal from './Modal'

function createBgStyles(config) {
  const styles = {}
  for (let i in config) {
    if (config[i].type === 'image') {
      styles[i] = { backgroundImage: `url(${config[i].value})` }
    }
  }
  return styles
}

function getUrlQuery() {
  return window.location.search.replace('?', '')
}

const prizeUrl = `https://m.black-unique.com/?utm_source=tuia&utm_medium=full&utm_campaign=heika&channel_hash=ec879f0dfcbe3c55f4c5ccf71c64f59f&${getUrlQuery()}`

const prizeConfig = {
  // 中奖次序
  hitPrize: [1, 5, 2],
  // 奖品配置
  cells: [
    {
      // 奖品在九宫格中的序号
      ind: 1,
      // 奖品图片
      prizePic: '//yun.dui88.com/b830b4c1-71a4-4921-9e93-5cdd0f22147f.png',
      link: `https://m.black-unique.com/?utm_source=tuia&utm_medium=full&utm_campaign=heika&channel_hash=ec879f0dfcbe3c55f4c5ccf71c64f59f&${getUrlQuery()}`
    },
    {
      ind: 2,
      prizePic: '//yun.dui88.com/b830b4c1-71a4-4921-9e93-5cdd0f22147f.png'
    },
    {
      ind: 5,
      prizePic: '//yun.dui88.com/b830b4c1-71a4-4921-9e93-5cdd0f22147f.png'
    }
  ]
}

const DELAY = 200
const SLOW_DOWN = 8
const CHECKED_INDEX = 1

export default {
  props: {
    config: {
      type: Object,
      default: {}
    }
  },
  components: {
    Modal
  },
  data() {
    return {
      start: false,
      delay: DELAY,
      slowDown: SLOW_DOWN,
      checkedIndex: CHECKED_INDEX,
      // 分隔符
      totalTimes: prizeConfig.hitPrize.length, // 抽奖总次数
      currentTime: 0, // 当前第几次抽奖
      prizes: [], // 中奖的奖品
      // 模态窗
      ruleModalVisible: false,
      prizeModalVisible: false,
      noPrizeModalVisible: false,
      myPrizeModalVisible: false
    }
  },
  computed: {
    currentPrizeIndex() {
      return prizeConfig.hitPrize[this.currentTime - 1]
    },
    // 剩余次数
    restTimes() {
      return this.totalTimes - this.currentTime
    },
    currentPrize() {
      return prizeConfig.cells.find(({ ind }) => ind === this.currentPrizeIndex)
    },
    // 已获取的奖品数量
    prizeNum() {
      return this.prizes.length
    }
  },
  methods: {
    initRolling() {
      this.start = false
      this.delay = DELAY
      this.slowDown = SLOW_DOWN
      this.checkedIndex = CHECKED_INDEX
    },
    startRolling() {
      const { delay, slowDown, checkedIndex } = this
      setTimeout(() => {
        if (delay > 200 && checkedIndex === this.currentPrizeIndex) {
          if (this.currentPrizeIndex === 1) {
            this.showPrizeModal()
            this.prizes.push(this.currentPrize)
          } else {
            this.showNoPrizeModal()
          }
          return this.initRolling()
        }
        if (checkedIndex > 7) {
          this.checkedIndex = 1
        } else {
          this.checkedIndex += 1
        }
        if (slowDown < 0) {
          this.delay += 30
        } else {
          this.delay = delay < 80 ? 80 : delay - 30
        }
        console.log(delay, slowDown)
        if (delay <= 80) this.slowDown = slowDown - 1
        this.startRolling()
      }, delay)
    },
    handleClick() {
      // 没有抽奖次数，不给抽奖
      if (this.restTimes === 0) {
        return toast('没有抽奖机会了')
      }
      if (window.JIMU.log) {
        window.JIMU.log.sendClickData({ location: 1 })
      }
      this.start = true
      this.currentTime += 1
      console.log('看下当前currentPrizeIndex', this.currentPrizeIndex)
      this.startRolling()
    },
    // 活动规则
    showRuleModal() {
      if (window.JIMU.log) {
        window.JIMU.log.sendClickData({ location: 4 })
      }
      this.ruleModalVisible = true
    },
    handleRuleModalClose() {
      this.ruleModalVisible = false
    },
    // 中奖弹窗
    showPrizeModal() {
      if (window.JIMU.log) {
        window.JIMU.log.sendClickData({ location: 2 })
      }
      this.prizeModalVisible = true
    },
    handlePrizeModalVisibleClose() {
      this.prizeModalVisible = false
    },
    getPrizeNow() {
      if (window.JIMU.log) {
        window.JIMU.log.sendClickData({ location: 3 })
      }
      window.location.href = prizeUrl
    },
    // 未中奖弹窗
    showNoPrizeModal() {
      if (window.JIMU.log) {
        window.JIMU.log.sendClickData({ location: 7 })
      }
      this.noPrizeModalVisible = true
    },
    handleNoPrizeModalVisibleClose() {
      if (window.JIMU.log) {
        window.JIMU.log.sendClickData({ location: 8 })
      }
      this.noPrizeModalVisible = false
    },
    // 我的奖品弹窗
    showMyPrizeModal() {
      if (window.JIMU.log) {
        window.JIMU.log.sendClickData({ location: 5 })
      }
      this.myPrizeModalVisible = true
    },
    handleMyPrizeModalVisibleClose() {
      this.myPrizeModalVisible = false
    },
    getPrize() {
      if (window.JIMU.log) {
        window.JIMU.log.sendClickData({ location: 6 })
      }
      window.location.href = prizeUrl
    }
  },
  render(h) {
    const {
      start,
      checkedIndex,
      config,
      restTimes,
      ruleModalVisible,
      prizeModalVisible,
      noPrizeModalVisible,
      myPrizeModalVisible
    } = this
    const bgStyle = createBgStyles(config)
    const cells = new Array(9).fill(1).map((v, index) => {
      const cls = cn({
        [styles.item]: true,
        [styles.checked]: !start || checkedIndex === index + 1
      })
      // console.log('让我看看渲染进度', cls)
      if (index === 8) {
        return (
          <div
            class={cls}
            key={index}
            style={bgStyle[`item0${index + 1}`]}
            onClick={this.handleClick}
          />
        )
      } else {
        return (
          <div class={cls} key={index} style={bgStyle[`item0${index + 1}`]} />
        )
      }
    })

    const ruleModal = {
      backgroundImage: `url(//yun.dui88.com/96f09c1e-5de4-4585-9ae3-b6dcb45fd8d0.png)`
    }

    const prizeModal = {
      backgroundImage:
        'url(//yun.dui88.com/11d29961-538b-4ba8-802b-39ee0a313c8b.png)'
    }

    const noPrizeModal = {
      backgroundImage:
        'url(//yun.dui88.com/efa7c889-c7c2-4fcc-8c31-58993eb60797.png)'
    }

    const myPrizeModal = {
      backgroundImage:
        'url(//yun.dui88.com/db1f9e39-c477-498a-a0c1-c73792d08832.png)'
    }

    const closeIcon = {
      backgroundImage:
        'url(//yun.dui88.com/288b553b-d88c-4338-ac68-5193c73a1358.png)'
    }

    return (
      <div class={styles.pageContainer} style="background-color:rgb(34,26,5)">
        <div class={styles.lottery} style={bgStyle.bg}>
          <div
            onClick={this.showRuleModal}
            class={styles.buttonLeft}
            style={bgStyle.buttonLeft}
          />
          <div
            onClick={this.showMyPrizeModal}
            class={styles.buttonRight}
            style={bgStyle.buttonRight}
          >
            {!!this.prizeNum && (
              <div class={styles.prizeNum}>{this.prizeNum}</div>
            )}
          </div>
          {/* 九宫格 */}
          <div class={styles.box} style={bgStyle.box}>
            {cells}
          </div>
          <div class={styles.restTimes}>
            今日还有<span>{restTimes}</span>次抽奖机会
          </div>
        </div>
        {/* 活动规则 */}
        <Modal onClose={this.handleRuleModalClose} visible={ruleModalVisible}>
          <div
            class={styles.closeButton}
            style={closeIcon}
            onClick={this.handleRuleModalClose}
          />
          <div class={styles.ruleModal} style={ruleModal} />
        </Modal>
        {/* 我的奖品 */}
        <Modal
          onClose={this.handleMyPrizeModalVisibleClose}
          visible={myPrizeModalVisible}
        >
          <div
            class={styles.closeButton}
            style={closeIcon}
            onClick={this.handleMyPrizeModalVisibleClose}
          />
          <div class={styles.myPrizeModal} style={myPrizeModal}>
            {this.prizeNum ? (
              <div>
                <div class={styles.prizeRow} onClick={this.getPrize} />
              </div>
            ) : (
              <div class={styles.noPrizeTips} />
            )}
          </div>
        </Modal>
        {/* 中奖 */}
        <Modal
          onClose={this.handlePrizeModalVisibleClose}
          visible={prizeModalVisible}
        >
          <div
            class={styles.closeButton}
            style={closeIcon}
            onClick={this.handlePrizeModalVisibleClose}
          />
          <div class={styles.prizeModal} style={prizeModal} />
          <div class={styles.hotArea} onClick={this.getPrizeNow} />
        </Modal>
        {/* 没中奖 */}
        <Modal
          onClose={this.handleNoPrizeModalVisibleClose}
          visible={noPrizeModalVisible}
        >
          <div
            class={styles.closeButton}
            style={closeIcon}
            onClick={this.handleNoPrizeModalVisibleClose}
          />
          <div class={styles.noPrizeModal} style={noPrizeModal} />
          <div
            class={styles.hotArea}
            onClick={this.handleNoPrizeModalVisibleClose}
          />
        </Modal>
      </div>
    )
  }
}
