import Guide from './Guide'
import Bubble from './Bubble'
import { clickTrack, exposeTrack, delay, clickWithCopy, jumpTo } from './eventTrack'

import Style from './index.less'

const name = 'bubble'
const CLS = `customTemplate-${name}`

export default {
  props: {
    widgetAttrs: Object,
    config: Object
  },

  data() {
    return {
      clickCountDone: 1,
      clickCount: 0,
      isCollecting: false,
      $main: null,
      $bubbleContainer: null
    }
  },

  async mounted() {
    this.$bubbleClassSelector = `.${Style['bubble']}`
    this.$btnSelector = `.${Style['btn']}`
    this.$bubbleContainer = document.getElementById('bubbles')
    /* 初始化泡泡们 */
    Bubble.init(this.$bubbleContainer, this.$bubbleClassSelector, this.config, Style)
    /* 引导手势 */
    Guide.init('guide')

    this.$main = document.querySelector(`.${Style[CLS]}`)
    this.$main.classList.add(Style['cutscene'])
    await delay(1000)

    /* 泡泡们登场 */
    Bubble.show(Style)
    await delay(300)

    /* 出现手势 */
    Guide.setTimeoutShow(600, Style)

    this.$main.classList.add(Style['ready'])
    this.$main.classList.remove(Style['cutscene'])

    /* 点击复制订单号 */
    const clickableSelectorList = [ this.$bubbleClassSelector, this.$btnSelector ]
    clickWithCopy(clickableSelectorList)

    // javascript监听pageshow事件阻止页面进入bfcache
    window.addEventListener('pageshow', function (e) {
      if (e.persisted) {
        window.location.reload()
      }
    })
  },

  methods: {
    // 泡泡点击
    async handleBubblesClcik(e) {
      /* 防重点击 */
      if (this.isCollecting) return
      this.isCollecting = true

      /* 点击次数++ */
      this.clickCount++
      this.$main.classList.add(Style['click'])

      /* 隐藏引导手势 */
      Guide.cancelTimeoutShow()
      Guide.hide(Style)

      /* 收集全部泡泡 */
      if (this.clickCount === this.clickCountDone) {
        /* 收集新泡泡并发送点击埋点 */
        Bubble.collect(e.target, true, false, Style)
        this.collectToFinal(false)
        this.isCollecting = false
      } else {
        /* 收集新泡泡并发送点击埋点 */
        await Bubble.collect(e.target, true, false, Style)
        /* 出现并曝光新泡泡 */
        Bubble.bubble(Style)
        /* 超时显示手势 */
        Guide.setTimeoutShow(2000, Style)
        this.isCollecting = false
      }
    },

    // 按钮点击
    async handleClick(e) {
      /* 防重点击 */
      if (this.isCollecting) return
      this.isCollecting = true

      /* 取消引导手势 */
      Guide.cancelTimeoutShow()
      Guide.hide(Style)
      clickTrack(12)

      await this.collectToFinal(false)
      this.isCollecting = false
    },

    async collectToFinal(bubbleClickTrack = false) {
      /* 收集所有泡泡并发送点击埋点 */
      Bubble.collectAll(bubbleClickTrack, Style)
      await delay(300)
      this.$main.classList.add(Style['final'])
      delay(700).then(() => {
        exposeTrack(13)
      })
      delay(2700).then(() => {
        const componentData = this.widgetAttrs
        const { jump } = componentData
        clickTrack(13).then(() => jumpTo(jump))
      })
      this.isCollecting = false
    }
  },

  render() {
    const { config } = this
    return (
      <div class={Style[CLS]}>
        <div class={Style['bg']} style={{backgroundImage: `url(${config.bgImg.value})`}} />

        <div class={Style['header']}>
          <div class={Style['title-sub']} style={{backgroundImage: `url(${config.titleSubImg.value})`}} />
          <div class={Style['title']} style={{backgroundImage: `url(${config.titleImg.value})`}} />
        </div>

        <div class={Style['main']}>
          <div class={Style['bubbles']} id="bubbles" onClick={this.handleBubblesClcik} />
          <div class={Style['guide']} id="guide" style={{backgroundImage: `url(${config.guideImg.value})`}} />
        </div>

        <div class={Style['footer']}>
          <div class={Style['success']} style={{backgroundImage: `url(${config.successImg.value})`}} />

          <div class={Style['tip-start']} style={{backgroundImage: `url(${config.tipStartImg.value})`}} />
          <div class={Style['tip500']} style={{backgroundImage: `url(${config.tip500Img.value})`}} />

          <div class={Style['envelope']}>
            <div class={Style['back']} style={{backgroundImage: `url(${config.backImg.value})`}} />
            <div class={Style['card']} style={{backgroundImage: `url(${config.cardImg.value})`}} />
            <div class={Style['front']} style={{backgroundImage: `url(${config.frontImg.value})`}} />

            <div class={Style['btn']} onClick={this.handleClick}>
              <div class={Style['btn-real']} style={{backgroundImage: `url(${config.btnImg.value})`}} />
              <div class={Style['btn-light']} style={{backgroundImage: `url(${config.btnLightImg.value})`}} />
            </div>

            <div class={Style['result']}>
              <div class={Style['generate']} style={{backgroundImage: `url(${config.generateImg.value})`}} />
              <div class={Style['max']} style={{backgroundImage: `url(${config.maxImg.value})`}} />
              <div class={Style['loading']} style={{backgroundImage: `url(${config.loadingImg.value})`}} />
            </div>
          </div>
        </div>

      </div>
    )
  }
}
