import interestList from './interests'
import { exposeTrack, clickTrack, delay } from '../eventTrack'

/**
 * 得到一个两数之间的随机整数
 * 含最小值，不含最大值
 * @param {Number} min 最小值
 * @param {Number} max 最大值
 */
// const getRandomInt = (min, max) => {
//   min = Math.ceil(min)
//   max = Math.floor(max)
//   return Math.floor(Math.random() * (max - min)) + min
// }

const Bubble = {
  $parent: null,
  /**
   * 当前所有泡泡
   */
  $bubbleList: null,

  /**
   * 显示泡泡的个数
   */
  bubbleNum: 8,

  availableList: [],

  /**
   * 初始化
   * @param {Array} bubbleList 泡泡们的信息
   */
  init(
    $parent = document.getElementById('bubbles'),
    bubbleClassSelector,
    imgConfig = null,
    bubbleList = interestList
  ) {
    if (!imgConfig) return
    this.$parent = $parent

    /* 利益点随机排序 */
    // interestList.sort(() => Math.random() - 0.5)

    // 组装可配置背景图片数据
    for (let key in imgConfig) {
      interestList.filter(item => {
        if (key.includes(item.name)) {
          item.imgUrl = imgConfig[key].value
        }
      })
    }

    /* 创建 DOM */
    interestList.forEach((value, index) => {
      if (index >= this.bubbleNum) {
        this.availableList.push(value)
      } else {
        const bubble = this.generate(bubbleClassSelector, value, index)
        this.$parent.append(bubble)
      }
    })

    /* 选择 DOM */
    this.$bubbleList = document.querySelectorAll(bubbleClassSelector)
  },

  /**
   * 生成一个泡泡元素
   * @param {Object} interest 利益点信息
   * @param {Number} position 位置索引
   * @returns {ZeptoCollection} 泡泡 Zepto
   */
  generate(bubbleClassSelector, interest, position) {
    const { location, name, imgUrl } = interest

    const bubble = document.createElement('div')
    bubble.setAttribute('class', bubbleClassSelector.slice(1))
    bubble.setAttribute('data-name', name)
    bubble.setAttribute('data-index', position)
    bubble.setAttribute('data-location', location)

    bubble.style.backgroundImage = 'url(' + imgUrl + ')'
    return bubble
  },

  /**
   * 登场
   */
  show(Style, $bubbleList = this.$bubbleList) {
    /* 曝光 */
    $bubbleList.forEach($bubble => {
      $bubble.classList.remove(Style['in'], Style['out'])
      $bubble.classList.add(Style['in'])
      const { location } = $bubble.dataset
      exposeTrack(location)
    })
  },

  /**
   * 收集一个泡泡
   * @param {HTMLElement} $target 收集的泡泡 HTML 元素
   * @param {Boolean} sendLog 是否发送点击埋点
   * @param {Boolean} animationDelay 动画是否延迟播放
   */
  async collect($target, sendLog = true, animationDelay = false, Style) {
    const outClassList = [ Style['out'] ]

    animationDelay && outClassList.push(Style['out-delay'])

    $target.classList.add(...outClassList)

    /* 点击埋点 */
    sendLog && clickTrack($target.dataset.location)

    await delay(200)
  },

  /**
   * 出现一个新泡泡
   */
  bubble(Style) {
    /* 找到已经收集过的泡泡位置 */
    const $targetBubble = this.$parent.find('.out')

    /* 新的利益点 */
    const newInterest = this.availableList.pop()

    /* 没有新的利益点时 */
    if (!newInterest) return

    /* 替换泡泡利益点 */
    const { location = -1, name = 'default' } = newInterest
    $targetBubble.data('location', location)
    $targetBubble.data('name', name)

    /* 重新出场 */
    this.show($targetBubble)

    /* 更新泡泡列表 */
    this.$bubbleList = document.querySelector(`.${Style['bubble']}`)
  },

  /**
   * 收集所有泡泡
   */
  collectAll(sendLog = false, Style) {
    this.$bubbleList.forEach(($bubble) => {
      if ($bubble.classList.contains(Style['out'])) {
      } else {
        this.collect($bubble, sendLog, true, Style)
      }
    })
  }
}

export default Bubble
