const path = require('path')

const skin = process.env.skin

const getEntry = isDev => {
  if (isDev) {
    return path.resolve(__dirname, `../index.js`)
  }
  return {
    [skin]: path.resolve(__dirname, `../containers/${skin}/index.js`)
  }
}

const getStyle = isDev => {
  const specPath = [/node_modules|global.less/]
  const cssSourceMap = !!isDev
  const rule = [
    {
      // 手机版CSS处理
      test: /(\.less|\.css)$/,
      exclude: specPath,
      use: [
        { loader: 'style-loader' },
        {
          loader: 'css-loader',
          options: {
            sourceMap: true,
            modules: {
              mode: 'local',
              localIdentName: '[local]__[hash:base64:5]'
            }
          }
        },
        {
          loader: 'px2rem-loader',
          options: {
            remUnit: 200
          }
        },
        {
          loader: 'less-loader',
          options: {
            javascriptEnabled: true,
            sourceMap: cssSourceMap
          }
        }
      ]
    },
    {
      test: /\.(le|c)ss/,
      include: specPath,
      use: [
        {
          loader: 'style-loader'
        },
        {
          loader: 'css-loader?sourceMap'
        },
        {
          loader: 'px2rem-loader',
          options: {
            remUnit: 100
          }
        },
        {
          loader: 'less-loader',
          options: {
            javascriptEnabled: true,
            sourceMap: isDev
          }
        }
      ]
    }
  ]

  return rule
}

module.exports = {
  getEntry,
  getStyle
}
