const path = require('path')
const VueLoaderPlugin = require('vue-loader/lib/plugin')
const HtmlWebpackPlugin = require('html-webpack-plugin')
const HtmlWebpackHarddiskPlugin = require('html-webpack-harddisk-plugin')
const config = require('./config')
const { getEntry } = require('./webpack.util')

const isProd = process.env.NODE_ENV === 'prod'
const skin = process.env.skin

module.exports = {
  entry: getEntry(true),
  output: {
    path: path.join(__dirname, '../dist/assets/'),
    filename: `[name]-[hash].js`,
    publicPath: isProd ? config['build'].assetsPublicPath : '/',
    library: `[name]-[hash]`,
    libraryTarget: 'umd',
    umdNamedDefine: true
  },
  module: {
    rules: [
      {
        test: /\.(js|jsx)$/,
        enforce: 'pre',
        loader: 'eslint-loader',
        options: {
          fix: true
        }
      },
      {
        test: /\.(js|jsx)$/,
        loader: 'babel-loader?cacheDirectory=true',
        exclude: /node_modules/
      },
      {
        test: /\.(gif|jpg|png|woff|svg|eot|ttf)\??.*$/,
        loader: 'url-loader'
      },
      {
        test: /\.(html|tpl)$/,
        loader: 'html-loader'
      },
      {
        test: /\.ejs$/,
        loader: 'ejs-loader'
      },
      {
        test: /\.vue$/,
        loaders: [
          {
            loader: 'vue-loader',
            options: {}
          }
        ]
      }
    ]
  },
  resolve: {
    extensions: ['.js', '.jsx'],
    alias: {
      ct: path.join(__dirname, '../'),
      '@skin': path.join(__dirname, `../containers/${skin}`)
    }
  },
  externals: {
    swiper: 'Swiper'
  },
  plugins: [
    new VueLoaderPlugin(),
    new HtmlWebpackPlugin({
      JIMU_ENV: process.env.NODE_ENV,
      // alwaysWriteToDisk: true,
      // chunks: ['customTemplate'],
      filename: 'index.html',
      template: path.resolve(__dirname, `../index.html`)
    }),
    new HtmlWebpackHarddiskPlugin()
  ]
}
