const https = require('https')
const http = require('http')
const sizeOf = require('image-size')

function action(imgUrl, key) {
  return new Promise((resolve, reject) => {
    if (imgUrl && imgUrl.includes('https:')) {
      https
        .get(imgUrl, response => {
          let chunks = []
          response
            .on('data', chunk => {
              chunks.push(chunk)
            })
            .on('end', () => {
              const buffer = Buffer.concat(chunks)
              resolve(Object.assign({}, sizeOf(buffer), { key }))
            })
        })
        .on('error', error => {
          reject(error)
        })
    } else {
      http
        .get(imgUrl.indexOf('//') ? imgUrl : `http:${imgUrl}`, response => {
          let chunks = []
          response
            .on('data', chunk => {
              chunks.push(chunk)
            })
            .on('end', () => {
              const buffer = Buffer.concat(chunks)
              resolve(Object.assign({}, sizeOf(buffer), { key }))
            })
        })
        .on('error', error => {
          reject(error)
        })
    }
  })
}

const fetchImgSize = async config => {
  const promiseArr = []
  for (const key in config) {
    if (config[key].type === 'image') {
      promiseArr.push(action(config[key].value, key))
    }
  }
  const result = await Promise.all(promiseArr)
  result.map(item => {
    config[item.key].width = item.width
    config[item.key].height = item.height
  })
  return config
}

module.exports = fetchImgSize
