const path = require('path')
const fs = require('fs')
const chalk = require('chalk')
const config = require('../config')
const fetchImgSize = require('./fetchImgSize')

const skin = process.env.skin

function writeFile(url, data) {
  return new Promise((resolve, reject) => {
    fs.writeFile(url, data, error => {
      if (error) {
        reject(error)
      } else {
        resolve(true)
      }
    })
  })
}

const exportConfig = async imgConfig => {
  const newConfig = await fetchImgSize(imgConfig)

  let script, skinName
  const targetPath = path.join(__dirname, '../../dist/assets')
  const readDir = fs.readdirSync(targetPath)
  readDir.map(item => {
    if (item.includes(skin)) {
      script = item
      skinName = item.split('.')[0]
    }
  })
  const url = path.join(__dirname, `../../containers/${skin}/config.json`)
  const content = {
    skinName,
    script: config['build'].assetsPublicPath + script,
    config: newConfig
  }

  try {
    await writeFile(url, JSON.stringify(content))
    console.log(chalk.cyan('  json配置文件写入成功，请前往皮肤目录下复制\n'))
  } catch (error) {
    console.log(
      chalk.red('  json配置文件写入失败\n')
    )
  }
}

module.exports = exportConfig
