const path = require('path')
const chalk = require('chalk')
const webpack = require('webpack')
const TuiaAutoUpload = require('tuia-auto-upload')

const config = require('./config')
const webpackConfig = require('./webpack.prod')
const exportConfig = require('./scripts/exportConfig')
const skin = process.env.skin

let picConfig
try {
  picConfig = require(`../containers/${skin}/config.js`)
} catch (error) {
  throw new Error(`请前往 ${skin} 皮肤文件夹下填写 config.js 配置项`)
}

webpack(webpackConfig, async (err, stats) => {
  if (err) throw new Error(err)

  process.stdout.write(stats.toString({
    colors: true,
    modules: false,
    children: false,
    chunks: false,
    chunkModules: false
  }) + '\n\n')

  console.log(chalk.cyan('  Build complete.\n'))

  const uploader = await new TuiaAutoUpload({
    dir: path.join(__dirname, '../dist/assets/'),
    originDir: config.publicPath,
    internal: false
  })

  await uploader.start()
  await exportConfig(picConfig)
})
