import WechatElement from './element'
import copy from 'copy-to-clipboard'
import toast from '../../libs/toast'
import CommonClick from '../../constructors/common-click'
import { nativeSdkBridge } from '../../libs/nativeSdkBridge'
import styles from '../widgets.less'

export default {
  props: {
    widgetAttrs: Object
  },

  methods: {
    handleClick() {
      copy(this.widgetAttrs.wechat.username)
      if(this.widgetAttrs.jump.isEvokeDisable){
        return
      }
      nativeSdkBridge('TAHandlerShowJFDialog', {}, () => {
        toast('复制成功')
      })
    }
  },

  render() {
    return (
      <CommonClick
        widgetType='wechat'
        widgetAttrs={this.widgetAttrs}
      >
        <div
          id={this.widgetAttrs.id}
          className={styles.widget}
          style={this.widgetAttrs.style}
          onClick={this.handleClick}
        >
          <WechatElement widgetAttrs={this.widgetAttrs} />
        </div>
      </CommonClick>
    )
  }
}
