import cn from 'classnames'
import log from '../../libs/log'
import styles from '../widgets.less'

export default {
  props: {
    widgetAttrs: Object
  },

  data() {
    return {
      player: null,
      srcVideo: '',
      videoBgStyle: {
        'backgroundImage': `url(${this.widgetAttrs.srcImage})`
      },
      videoBgEndStyle: {
        'backgroundImage': `url(${this.widgetAttrs.srcEndImage})`
      },
      isVolume: true,
      isStart: false,
      isEnd: false
    }
  },

  mounted() {
    const { autoPlay } = this.widgetAttrs
    if (autoPlay.enable) {
      this.init(autoPlay.delay)
    } else {
      this.init()
    }
  },

  destroyed() {
    console.log('video destroy')
  },

  methods: {
    init(delay = 0) {
      const oScript = document.createElement('script')
      oScript.type = 'text/javascript'
      oScript.src = '//yun.tuisnake.com/h5-mami/jsmpeg.min.js'
      document.head.appendChild(oScript)

      this.srcVideo = this.widgetAttrs.srcWeak

      window.TA && window.TA.network && window.TA.network.add(() => {
        if (window.TA.network.strong) {
          this.srcVideo = this.widgetAttrs.srcStrong
        }
      })

      setTimeout(() => {
        this.player = this.initVideo(this.srcVideo, delay)
      }, 500)
    },

    initVideo(videoSrc, delay = 0) {
      if (!window.JSMpeg) return false
      const player = new window.JSMpeg.Player(videoSrc, {
        disableGl: false,
        disableWebAssembly: true,
        loop: false,
        autoplay: false,
        canvas: document.querySelector('#video-canvas'),
        onPlay: () => {
          console.log('video paly start')
          log.sendClickData({
            video_start_timestamp: new Date().getTime()
          }, () => {})
          this.isStart = true

          console.log('video load end')
          log.sendClickData({
            video_endload_timestamp: new Date().getTime()
          }, () => {})
        },
        onEnded: () => {
          console.log('video paly end')
          log.sendClickData({
            video_end_timestamp: new Date().getTime()
          }, () => {})

          this.isEnd = true
        },

        onSourceEstablished: () => {
          console.log('video load start')
          log.sendClickData({
            video_loading_timestamp: new Date().getTime()
          }, () => {})
        }
      })

      // 开始播放
      setTimeout(() => {
        this.player.play()
      }, delay * 1000 - 500 || 0)

      // 解除消音
      if (player.audioOut) {
        if (!player.audioOut.unlocked) player.audioOut.unlock()
      }
      player.volume = 1

      setTimeout(() => {
        if (!player.audioOut.unlocked) {
          player.volume = 0
          this.isVolume = false
        }
      }, 0)

      return player
    },

    toggleVolume() {
      this.isVolume = !this.isVolume

      this.player.volume = +!this.player.volume

      // 解除消音
      if (this.player.audioOut) {
        if (!this.player.audioOut.unlocked) this.player.audioOut.unlock()
      }
    }
  },

  render() {
    return (
      <div
        id={this.widgetAttrs.id}
        class={styles.widget}
        style={this.widgetAttrs.style}
      >
        <canvas id="video-canvas" class={styles.video} />

        <div
          class={cn(styles['icon-volume'], !this.isVolume ? styles['icon-volume-close'] : '')}
          onClick={this.toggleVolume}
        />

        { !this.isStart
          ? <div class={styles['video-bg']} style={this.videoBgStyle} />
          : ''
        }

        { this.isEnd
          ? <div class={styles['video-bg']} style={this.videoBgEndStyle} />
          : ''
        }
      </div>
    )
  }
}
