import toast from '../../libs/toast'
import CommonJump from '../../constructors/common-click/common-jump'
import Style from './index.less'

export default {
  props: {
    target: Object
  },

  data() {
    return {
      pricePool: [],
      begin: false
    }
  },

  methods: {
    start() {
      const { name, awardSetting, baseContent } = this.target
      const { startTime, endTime } = baseContent

      if (Date.now() <= startTime || Date.now() >= endTime) {
        toast('活动不在参与时间范围内')
      }

      if (!this.begin) {
        this.begin = true

        let resultInfo = this.getAngleRotate()
        this.animation(resultInfo.animateToAngle)

        const popupId = awardSetting[resultInfo.priceIndex].popupId

        setTimeout(() => {
          this.begin = false
          CommonJump({
            componentData: this.target,
            jump: { type: 'popup' },
            options: { location: name },
            popupCallback: () => {
              this.$store.commit('showPopup', popupId)
            },
            closeCallback: () => {
              this.$store.commit('hidePopup', popupId)
            }
          })
        }, 2500)
      }
    },
    animation(circle) {
      const wheel = this.$refs.wheelRef
      const initDeg = this.getCurAngle()
      wheel.style.transform = `rotate(${circle + initDeg - (initDeg % 360)}deg)`
    },
    getCurAngle() {
      const wheel = this.$refs.wheelRef
      return wheel.style.transform.replace(/[^0-9]/gi, '') * 1
    },
    getAngleRotate() {
      const randomIndex = Math.floor(Math.random() * 100)
      // 中奖奖品旋转角度
      const rotateAngles = [1410, 1350, 1290, 1230, 1170, 1110].map(
        item => item + 360
      )
      const priceIndex = this.pricePool[randomIndex]
      return {
        animateToAngle: rotateAngles[priceIndex],
        priceIndex
      }
    }
  },

  mounted() {
    const { awardSetting } = this.target

    // 大于零的奖品逻辑
    awardSetting.forEach((item, index) => {
      const probability = Number(item.probability) || 0
      if (probability) {
        for (var i = 0; i < probability * 100; i++) {
          this.pricePool.push(index)
        }
      }
    })

    // 等于零的奖品逻辑，平摊剩余的可能性
    const zeroArr = []
    awardSetting.forEach((item, idx) => {
      if (Number(item.probability) === 0) zeroArr.push(idx)
    })
    let zeroArrIndex = 0
    for (var i = this.pricePool.length; i < 100; i++) {
      this.pricePool.push(zeroArr[zeroArrIndex])
      if (zeroArrIndex >= zeroArr.length - 1) {
        zeroArrIndex = 0
      } else {
        zeroArrIndex++
      }
    }
  },

  render() {
    const { visualElement, awardSetting } = this.target
    const { bgImg, btnImg, guideImg, borderColor } = visualElement

    return (
      <div class={Style.turntable}>
        <div
          class={Style.turntable_bgColor}
          style={{ backgroundColor: borderColor }}
        />
        <img
          src="//yun.tuisnake.com/h5/activity/turntable_circle/images/radius-2.png"
          alt=""
          class={Style.turntable_bgBorder}
          onDragStart={event => {
            event.preventDefault()
          }}
        />
        <div class={Style.turntable_bg} ref="wheelRef">
          {bgImg && (
            <img
              src={bgImg}
              class={Style.turntable_bg_bgImg}
              onDragStart={event => {
                event.preventDefault()
              }}
            />
          )}
          {btnImg && (
            <div onClick={this.start}>
              <img
                src={btnImg}
                class={Style.turntable_bg_Click}
                onDragStart={event => {
                  event.preventDefault()
                }}
              />
            </div>
          )}
          {awardSetting.map((item, index) => {
            return (
              <div
                class={Style.turntable_bg_secImg}
                style={{
                  transform: `rotate(${60 * (index + 1)}deg) skewY(30deg)`
                }}
                key={index}
              >
                {item.img && (
                  <div class={Style.turntable_bg_secImg_inner}>
                    {item.awardName}
                    <img src={item.img} />
                  </div>
                )}
              </div>
            )
          })}
        </div>
        {guideImg && (
          <img
            class={Style.turntable_pointer}
            src={guideImg}
            onDragStart={event => {
              event.preventDefault()
            }}
          />
        )}
      </div>
    )
  }
}
