import PopupBody from './popup-body'
import Close from './close.png'
import styles from './index.less'

export default {
  props: {
    widgetAttrs: Object
  },

  methods: {
    handleClose() {
      this.$store.commit('hidePopup')
    }
  },

  render() {
    const { closeIcon } = this.widgetAttrs

    return (
      <div>
        <div class={styles['popup-mask']} />
        <div class={styles['popup-wrapper']}>
          {closeIcon.enable === 1 && (
            <img class={styles['close']} src={Close} onClick={this.handleClose}/>
          )}
          <PopupBody widgetAttrs={this.widgetAttrs} />
        </div>
      </div>
    )
  }
}
