import { Field } from 'vant'
import { iconTypeMapping } from '../index'

export default {
  props: {
    formAttrs: Object,
    layout: String,
    inputLayout: String,
    className: String
  },

  data() {
    return {
    }
  },
  methods: {
    handleChange(val) {
      const { type, childType, key } = this.formAttrs
      const fieldId = `${type}_${childType}-${key}`
      this.$emit('update', val, fieldId)
    }
  },
  render: function(h) {
    const {
      title,
      placeholder,
      required,
      childType
    } = this.formAttrs
    return (
      <div class={this.className}>
        <Field
          required={!!required}
          label={this.layout === 'no-title' ? '' : title}
          placeholder={placeholder}
          left-icon={this.layout === 'icon' ? iconTypeMapping[childType] : ''}
          input-align={this.inputLayout}
          rows="3"
          autosize
          type="textarea"
          onInput={this.handleChange}
        />
      </div>
    )
  }
}
