import { Field, Popup, Picker } from 'vant'
import { iconTypeMapping } from '../index'

export default {
  props: {
    formAttrs: Object,
    layout: String,
    inputLayout: String,
    className: String
  },

  data() {
    return {
      content: '',
      show: false,
      selectOptions: [
        // 默认性别选择
        {
          text: '男',
          value: '1'
        },
        {
          text: '女',
          value: '0'
        }
      ]
    }
  },
  methods: {
    handleClick() {
      this.show = true
    },
    handleCancel() {
      this.show = false
    },
    handleConfirm(val) {
      this.content = val.text
      this.show = false
      const { type, childType, key } = this.formAttrs
      const fieldId = `${type}_${childType}-${key}`
      this.$emit('update', val.value, fieldId)
    },
    autoFill(value) {
      const { type, childType, key } = this.formAttrs
      const fieldId = `${type}_${childType}-${key}`
      if (childType === 'sex') {
        this.content = value
        this.$emit('update', value === '男' ? '1' : '0', fieldId)
      }
    },
  },
  render: function(h) {
    const {
      title,
      placeholder,
      required,
      options,
      childType
    } = this.formAttrs

    const columns = options ? options.map(item => {
      return { text: item, value: item }
    }) : this.selectOptions

    return (
      <div class={this.className}>
        <Field
          v-model={this.content}
          required={!!required}
          input-align={this.inputLayout}
          label={this.layout === 'no-title' ? '' : title}
          left-icon={this.layout === 'icon' ? iconTypeMapping[childType] : ''}
          placeholder={placeholder}
          onClick={this.handleClick}
          readonly
        />
        <Popup v-model={this.show} position="bottom" get-container="body" overlay={false}>
          <Picker
            show-toolbar
            columns={columns}
            onCancel={this.handleCancel}
            onConfirm={this.handleConfirm} />
        </Popup>
      </div>
    )
  }
}
