import { Field, Popup, Area } from 'vant'
import { iconTypeMapping } from '../index'
import areaList from './area'

export default {
  props: {
    formAttrs: Object,
    layout: String,
    inputLayout: String,
    className: String
  },

  data() {
    return {
      content: '',
      show: false
    }
  },
  methods: {
    handleClick() {
      this.show = true
    },
    handleCancel() {
      this.show = false
    },
    handleConfirm(val) {
      this.show = false
      const value = val.map(item => item ? item.name : '')
      this.content = `${value[0]},${value[1]},${value[2]}`
      const { type, childType, key } = this.formAttrs
      const fieldId = `${type}_${childType}-${key}`
      this.$emit('update', value, fieldId)
    },
    autoFill(value) {
      this.content = `${value[0]},${value[1]},${value[2]}`
      const { type, childType, key } = this.formAttrs
      const fieldId = `${type}_${childType}-${key}`
      this.$emit('update', value, fieldId)
    }
  },
  render: function(h) {
    const {
      title,
      placeholder,
      required,
      childType
    } = this.formAttrs
    return (
      <div class={this.className}>
        <Field
          v-model={this.content}
          required={!!required}
          label={this.layout === 'no-title' ? '' : title}
          left-icon={this.layout === 'icon' ? iconTypeMapping[childType] : ''}
          input-align={this.inputLayout}
          placeholder={placeholder}
          onClick={this.handleClick}
          readonly
        />
        <Popup v-model={this.show} position="bottom" get-container="body" overlay={false}>
          <Area
            area-list={areaList}
            value="110101"
            onCancel={this.handleCancel}
            onConfirm={this.handleConfirm}
          />
        </Popup>
      </div>
    )
  }
}
