import { Field } from 'vant'
import { iconTypeMapping } from '../index'

export default {
  props: {
    formAttrs: Object,
    layout: String,
    inputLayout: String,
    className:  String,
  },

  data() {
    return {
      value: ''
    }
  },
  methods: {
    autoFill(value) {
      this.value = value
      this.handleChange(value)
    },
    handleChange(val) {
      const { type, childType, key } = this.formAttrs
      const fieldId = `${type}_${childType}-${key}`
      this.$emit('update', val, fieldId)
    }
  },
  render: function(h) {
    const {
      title,
      placeholder,
      childType,
      required
    } = this.formAttrs
    return (
      <div class={this.className}>
        <Field
          v-model={this.value}
          required={!!required}
          label={this.layout === 'no-title' ? '' : title}
          left-icon={this.layout === 'icon' ? iconTypeMapping[childType] : ''}
          input-align={this.inputLayout}
          placeholder={placeholder}
          onInput={this.handleChange}
        />
      </div>
    )
  }
}
