import { Cell, Checkbox, CheckboxGroup } from 'vant'
import { iconTypeMapping } from '../index'

export default {
  props: {
    formAttrs: Object,
    layout: String,
    inputLayout: String,
    className:  String
  },

  data() {
    return {
      result: []
    }
  },
  methods: {
    handleChange(val) {
      const { type, childType, key } = this.formAttrs
      const fieldId = `${type}_${childType}-${key}`
      this.$emit('update', val, fieldId)
    }
  },
  render: function(h) {
    const { title, options, childType } = this.formAttrs

    // 自定义下拉选项
    let radioOptions = options ? options.split('\n') : []

    return (
      <div class={this.className}>
        <Cell title={this.layout === 'no-title' ? '' : title} icon={this.layout === 'icon' ? iconTypeMapping[childType] : ''}>
          <div class="van-field__body">
            <div class={`van-field__control radio-container van-field__control--${this.inputLayout}`}>
              <CheckboxGroup v-model={this.result} onChange={this.handleChange}>
                { radioOptions.map(item => {
                  return (<Checkbox name={item}>{item}</Checkbox>)
                })}
              </CheckboxGroup>
            </div>
          </div>
        </Cell>
      </div>
    )
  }
}
