import CommonClick from '../../constructors/common-click'
import styles from '../widgets.less'

export default {
  props: {
    widgetAttrs: Object,
    customClick: Function || null
  },

  render() {
    const { id, text, style } = this.widgetAttrs
    return (
      <CommonClick
        widgetType='button'
        widgetAttrs={this.widgetAttrs}
        customClick={this.customClick}
      >
        <div id={id} class={styles.widget} style={style}>
          <div
            style={{
              position: 'absolute',
              top: '50%',
              width: '100%',
              transform: 'translateY(-50%)',
              whiteSpace: style.whiteSpace
            }}
          >
            {text}
          </div>
        </div>
      </CommonClick>
    )
  }
}
