import axios from 'axios'

//设置axios为form-data
const instance = axios.create()
instance.defaults.headers.post['Content-Type'] =
  'application/x-www-form-urlencoded'
instance.defaults.headers.get['Content-Type'] = 'application/x-www-form-urlencoded'
instance.defaults.transformRequest = [
  function(data) {
    let ret = ''
    for (let it in data) {
      ret += encodeURIComponent(it) + '=' + encodeURIComponent(data[it]) + '&'
    }
    return ret.substr(0, ret.length - 1)
  }
]

const transPxAttrs = [
  'borderBottomLeftRadius',
  'borderBottomRightRadius',
  'borderTopLeftRadius',
  'borderTopRightRadius',
  'borderWidth',
  'width',
  'height',
  'top',
  'left',
  'right',
  'bottom'
]

const utils = {
  ajax(options) {
    return new Promise((resolve, reject) => {
      instance(options)
        .then(result => {
          const { data } = result
          resolve(data)
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  /**
   * 获取url中特定字符串的值
   * @param {*} name 字符串key
   * @param {*} path 默认为页面链接地址，也可自己传某段string
   */
  getUrlParameter(name, path = window.location.href) {
    const result =
      decodeURIComponent(
        (new RegExp('[?|&]' + name + '=([^&;]+?)(&|#|;|$)').exec(path) || [
          undefined,
          ''
        ])[1].replace(/\+/g, '%20')
      ) || null
    return result ? result.split('/')[0] : ''
  },
  /**
   * 格式化url，添加参数
   *
   * @param {*} url
   * @param {*} params
   * @returns
   */
  formatUrl(url, params) {
    if (!url) {
      return ''
    }
    let keys = Object.keys(params)
    if (keys.length === 0) {
      return url
    }
    let base = url.indexOf('?') > -1 ? `${url}&` : `${url}?`
    return keys.reduce((acc, v, i) => {
      if (i === 0) {
        return (acc += `${v}=${params[v]}`)
      } else {
        return (acc += `&${v}=${params[v]}`)
      }
    }, base)
  },

  // 落地页不同宽度转换规则
  fitSize(size, wrapWidth) {
    if (size === 0) {
      return size
    }
    if (wrapWidth === '375px') {
      return (parseInt(size) && !String(size).includes('%')) ? parseInt(size) / 100 + 'rem' : size
    } else if (wrapWidth === '320px') {
      return (parseInt(size) && !String(size).includes('%')) ? (parseInt(size) * 2) / 200 + 'rem' : size
    }
  },

  // 判断类型函数
  checkType(obj) {
    const toString = Object.prototype.toString
    const map = {
      '[object Boolean]': 'boolean',
      '[object Number]': 'number',
      '[object String]': 'string',
      '[object Function]': 'function',
      '[object Array]': 'array',
      '[object Date]': 'date',
      '[object RegExp]': 'regExp',
      '[object Undefined]': 'undefined',
      '[object Null]': 'null',
      '[object Object]': 'object'
    }
    return map[toString.call(obj)]
  },

  transPx2Rem(sourceObj, wrapWidth) {
    for (let i in sourceObj) {
      if (this.checkType(sourceObj[i]) === 'object' || this.checkType(sourceObj[i]) === 'array') {
        sourceObj[i] = this.transPx2Rem(sourceObj[i], wrapWidth)
      } else {
        // px转换
        if (/px$/.test(sourceObj[i]) || this.inArray(transPxAttrs, i)) {
          if (!/rem$/.test(sourceObj[i])) {
            sourceObj[i] = this.fitSize(sourceObj[i], wrapWidth)
          }
        }
      }
    }

    return sourceObj
  },

  dateFormat(date, fmt) {
    date = new Date(date)
    const o = {
      'M+': date.getMonth() + 1, // 月份
      'd+': date.getDate(), // 日
      'h+': date.getHours(), // 小时
      'm+': date.getMinutes(), // 分
      's+': date.getSeconds(), // 秒
      'q+': Math.floor((date.getMonth() + 3) / 3), // 季度
      S: date.getMilliseconds() // 毫秒
    }
    if (/(y+)/.test(fmt)) {
      fmt = fmt.replace(
        RegExp.$1,
        (date.getFullYear() + '').substr(4 - RegExp.$1.length)
      )
    }
    for (const k in o) {
      if (new RegExp('(' + k + ')').test(fmt)) {
        fmt = fmt.replace(
          RegExp.$1,
          RegExp.$1.length === 1
            ? o[k]
            : ('00' + o[k]).substr(('' + o[k]).length)
        )
      }
    }
    return fmt
  },

  inArray(arr, value) {
    for (var i = 0; i < arr.length; i++) {
      if (value === arr[i]) {
        return true
      }
    }
    return false
  },

  loadScript(src, callback) {
    const script = document.createElement('script')
    const head = document.getElementsByTagName('head')[0]
    script.type = 'text/javascript'
    script.charset = 'UTF-8'
    script.src = src
    if (script.addEventListener) {
      script.addEventListener('load', function () {
        callback()
      }, false)
    } else if (script.attachEvent) {
      script.attachEvent('onreadystatechange', function () {
        const target = window.event.srcElement
        if (target.readyState === 'loaded') {
          callback()
        }
      })
    }
    head.appendChild(script)
  },

  deepClone(target) {
    const type = this.checkType(target)
    let cloneTarget
    if (type === 'Object') {
      cloneTarget = {}
    } else if (type === 'Array') {
      cloneTarget = []
    } else {
      return target
    }

    for (const key in target) {
      if (target.hasOwnProperty(key)) {
        if (this.checkType(target[key]) === 'Object' || this.checkType(target[key]) === 'Array') {
          cloneTarget[key] = this.deepClone(target[key])
        } else {
          cloneTarget[key] = target[key]
        }
      }
    }

    return cloneTarget
  }
}

export default utils
