/*
 * @Author: yrzhao
 * @Date: 2020-02-19 13:00:58
 * @Last Modified by: yrzhao
 * @Last Modified time: 2020-02-19 14:28:34
 */
/**
 * 此方法为落地页转化及自定义埋点方法
 * 引用： import log  from 'units/bussiness/log'
 */
/* 传参顺序与countLog中传参顺序不一致的原因： countLog传参顺序为历史问题，不作更改; log中传参顺序更符合开发习惯，callback放于末位 */
// const countLog = window.countLog

const log = {
  /**
   * 落地页转化
   * @param {Object} extraData 转化额外数据
   * @param {Function} cb 回调函数
   */
  init(extraData, cb) {
    if (window.countLog.ready) {
      window.countLog.ready(() => {
        window.countLog.init(cb, extraData)
      })
    } else window.countLog.init(cb, extraData)
  },
  /**
   * 落地页自定义埋点
   * @param {Object} extraData 埋点数据
   * @param {Function} cb 回调函数
   */
  sendClickData(extraData, cb) {
    if (window.countLog.ready) {
      window.countLog.ready(() => {
        window.countLog.sendClickData(cb, extraData)
      })
    } else window.countLog.sendClickData(cb, extraData)
  }
}

export default log
