// 测试自动填充表单
import PubSub from 'pubsub-js'
import utils from '../../libs/utils'
import { ajax } from '../../widgets/form/utils'
import Modal from './modal'
import Jiu from '@/styles/imgs/jiu.png'
import Nai from '@/styles/imgs/nai.png'

const testPage = [
  {
    id: 'MTMwNw',// 测试环境便于测试
    point: '#3ad4a28b'
  }, {
    id: 'NjUzOQ',// 线上环境-酒
    point: '#92742d8e'
  }, {
    id: 'NjU0MQ',// 线上环境-羊奶
    point: '#92742d8e'
  }
]

export default {
  data() {
    return {
      isAuth: false
    }
  },

  mounted() {
    const pageId = utils.getUrlParameter('id')
    const isTest = testPage.filter(item => item.id === pageId)
    if (isTest.length) {
      this.authorization()
    }
  },

  methods: {
    // 授权，自动填充表单
    authorization() {
      // 只触发授权一次
      if (this.isAuth) return
      ajax({
        url: '/sdk/put/queryActionConfig',
        data: {
          orderId: utils.getUrlParameter('a_oId'),
          userId: utils.getUrlParameter('userId'),
          consumerId: utils.getUrlParameter('a_cid'),
        },
        method: 'post',
        headers: { 'Content-Type': 'application/json' }
      }).then(res => {
        this.isAuth = true
        if (res.code === '0') {
          this.$store.commit('setNeedMonitor', res.data.needMonitor)
          // 是否支持自动填充表单，1-需要，0-不需要
          if (res.data.needMonitor) {
            this.$store.commit('handleTestPopup', {
              key: 'isShow',
              value: true
            })
            window.JIMU.log.sendClickData({
              type: 110,
              group: 1,
              location: 2,
              userId: utils.getUrlParameter('userId')
            })
          }
        } else {
          console.log(res.desc)
        }
      })
    },
    handleCancel() {
     // 取消埋点
      window.JIMU.log.sendClickData({
        type: 110,
        group: 1,
        location: 4,
        userId: utils.getUrlParameter('userId')
      })
    },
    handleOk() {
      this.$store.commit('setAuto', 1)
      // 马上领取授权
      window.JIMU.log.sendClickData({
        type: 110,
        group: 1,
        location: 3,
        userId: utils.getUrlParameter('userId')
      })
      this.queryMediaUserInfo()
      // 跳转锚点
      if (window.location.href.includes('#')) return
      const pageId = utils.getUrlParameter('id')
      const data = testPage.filter(item => item.id === pageId)
      window.location.href += data[0].point
    },
    // 获取用户信息
    queryMediaUserInfo() {
      ajax({
        url: '/sdk/put/queryMediaUserInfo',
        data: {
          userId: utils.getUrlParameter('userId'),
          orderId: utils.getUrlParameter('a_oId'),
          consumerId: utils.getUrlParameter('a_cid'),
        },
        method: 'post',
        headers: { 'Content-Type': 'application/json' }
      }).then(res => {
        if (res.code === '0' && res.data) {
          PubSub.publish('setUser', res.data)
        } else {
          Toast('获取失败，请自助填写')
        }
      }).catch(err => {
        console.log(err)
        Toast('获取失败，请自助填写')
      })
    }
  },

  render() {
    const {isShow } = this.$store.state
    const pageId = utils.getUrlParameter('id')
    return (
      <Modal
        show={isShow}
        cancel={this.handleCancel}
        ok={this.handleOk}
        styles={{
          width: '2.98rem',
          height: '3.79rem'
        }}
        contentImg={pageId === 'NjUzOQ' ? Jiu : Nai}
      />
    )
  }
}