import Widgets from '../widgets/allWidgets'
import styles from '../index.less'

import TestAutoFill from './popupForTest/index'

export default {
  updated() {
    this.initPageWrap()
  },

  methods: {
    /**
     * 初始化页面背景
     * @param {Object} pageConfig 页面背景配置项
     */
    initPageWrap() {
      const {
        backgroundColor,
        backgroundImage,
        backgroundRepeat
      } = this.$store.state.pageConfig
      const $body = document.querySelector('body')
      $body.style.backgroundColor = backgroundColor
      $body.style.backgroundRepeat = backgroundRepeat
      $body.style.backgroundImage = window.TA.isSupportWebp ? backgroundImage.replace('")', '?x-oss-process=image/format,webp') : backgroundImage
    }
  },

  render() {
    const { elementConfig, pageConfig } = this.$store.state
    const { width, height } = pageConfig
    return (
      <div>
        <div class={styles.land_wrap} style={{width, height}}>
          {elementConfig && elementConfig.map((item, idx) => {
            const SpecWidget = Widgets[item.type]
            return <SpecWidget widgetAttrs={item} key={idx} />
          })}
        </div>
        <TestAutoFill />
      </div>
    )
  }
}