import { NETVeify, buryAOId } from '../../libs/helper'
import toast from '../../libs/toast'
import CommonJump from './common-jump'
import copy from 'copy-to-clipboard'
import store from '../../store'

export default {
  props: {
    widgetType: String,
    widgetAttrs: Object,
    customClick: Function || null
  },

  data() {
    return {
      clicking: false
    }
  },

  methods: {
    handleClick() {
      const componentData = this.widgetAttrs
      const { jump, picValid, enable, copyText } = componentData
      /**
       * 防连续点击
       */
      if (this.clicking) {
        return
      } else {
        this.clicking = true
        setTimeout(() => {
          this.clicking = false
        }, 1000)
      }

      if (jump.type === 'link') {
        if (copyText) {
          copy(copyText)
        } else {
          buryAOId()
        }
      }

      // 普通组件是用picValid，表单提交是enable（尼玛为什么还不一样？？）
      if (picValid === 1 || enable === 1) {
        NETVeify()
          .then(() => {
            this.clickJump()
          })
          .catch(() => {
            toast('校验失败', 2000)
          })
      } else {
        this.clickJump()
      }
    },

    clickJump() {
      const self = this
      /**
       * 如有传入自定义事件，先执行掉
       * 注意：自定义事件必须是Promise，并返回true，如返回false，则不执行common-jump
       */
      if (this.customClick) {
        this.customClick().then(result => {
          if (result) {
            self.doJump()
          }
        })
      } else {
        self.doJump()
      }
    },

    doJump() {
      const componentData = this.widgetAttrs
      const { name, jump, picValid } = componentData

      let extraParam = {}
      picValid && (extraParam.sliderVerify = 1)

      CommonJump({
        componentData,
        jump,
        options: { location: name, ...extraParam },
        popupCallback: () => {
          store.commit('showPopup', jump.popupId)
        },
        closeCallback: () => {
          store.commit('hidePopup')
        }
      })
    }
  },

  render() {
    if (this.widgetType === 'mobile') {
      const tel = 'tel:' + this.widgetAttrs.mobile
      return (
        <a href={tel} onClick={this.handleClick}>
          {this.$slots.default}
        </a>
      )
    } else {
      return (
        <div onClick={this.handleClick}>
          {this.$slots.default}
        </div>
      )
    }
  }
}
