import React from 'react'

import { inject, observer } from 'mobx-react'

import { hot } from 'react-hot-loader'

import 'pro/styles/index.less'

@inject('userStore')
@observer
class App extends React.Component {
  componentDidMount() {
    this.props.userStore.getUserInfo()
  }

  render() {
    const { dataIsReady } = this.props.userStore
    const { children } = this.props
    return <div>{dataIsReady ? children : null}</div>
  }
}

export default hot(module)(App)
