import React, { Component } from 'react'
import Item from 'wp/constructors/item/index'
import ItemsStyle from '../items.less'
import { WechatType as type } from 'wp/utils/itemType'
import defaultAttrs from './attrs'
import { WechatScreenshot as screenshot } from 'wp/config/dragScreenshot'
import TuiaIcon from 'wp/constructors/fc/icon'
import store from 'wp/store'

@Item({
  type,
  defaultAttrs,
  screenshot,
  onDragIntoScene({ targetId }) {
    let obj = {}
    obj['style.left'] = '0px'
    obj['style.top'] = 'auto'
    obj['style.bottom'] = '0px'
    store.WPSceneStore.changeItemPropsById(targetId, obj)
  }
})
export default class WechatItem extends Component {
  render() {
    return (
      <div className={ItemsStyle['item']}>
        <TuiaIcon type="control_weixin" />
        微信
      </div>
    )
  }
}
