import React from 'react'
import { Upload, Spin, message } from 'antd'
import {
  uploadUrl,
  uploadBucket,
  imagePrefix,
  uploadStatusChangeGen,
  beforeUploadGen,
  staticResourcePrefix
} from 'wp/config'
import classnames from 'classnames'
import Style from './index.less'
import ColorPicker from 'pro/components/color-picker/index'
import { observer, inject } from 'mobx-react'
import CommonStyles from 'wp/config/commonStyle'
import TuiaIcon from 'wp/constructors/fc/icon'
import defaultAttrs from '../attrs'
import { TriggerableGuide } from 'wp/features/guide'
import { UploadErrorGuider } from 'wp/guides'
import { readImageProps } from 'wp/utils/helper'

@inject('WPSceneStore')
@observer
export default class VisualElement extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      activeKey: 'bgImg',
      loading: false,
      sizeError: null,
      typeError: null
    }
  }
  handleClick = activeKey => {
    this.setState({ activeKey })
  }
  render() {
    const { activeKey, loading } = this.state
    const { visualElement } = this.props
    const arr = [
      {
        label: '大转盘背景',
        key: 'bgImg'
      },
      {
        label: '转盘指针',
        key: 'guideImg'
      },
      {
        label: '点击按钮',
        key: 'btnImg'
      }
    ]
    let width = 0
    let height = 0
    switch (activeKey) {
      case 'bgImg':
        width = height = 546
        break
      case 'guideImg':
        width = 42
        height = 68
        break
      case 'btnImg':
        width = height = 168
        break
    }
    return (
      <div className={Style.visual_element}>
        <div className={Style.left_section}>
          {arr.map((item, key) => {
            return (
              <div key={key} className={Style.item_line}>
                <p className={Style.item_line_title}>{item.label}</p>
                <div
                  className={classnames({
                    [Style.img_wrap]: true,
                    [Style.active]: activeKey === item.key
                  })}
                  onClick={() => {
                    this.handleClick(item.key)
                  }}
                  style={{ backgroundImage: `url("${staticResourcePrefix}/masker@2x.png")` }}
                  onMouseEnter={() =>
                    this.setState({
                      [`${item.key}Close`]: true
                    })
                  }
                  onMouseLeave={() =>
                    this.setState({
                      [`${item.key}Close`]: false
                    })
                  }
                >
                  <img src={visualElement[item.key]} />
                  {this.state[`${item.key}Close`] &&
                    visualElement[item.key] !== '' && (
                    <TuiaIcon
                      type="icon-system_Close"
                      onClick={e => {
                        e.stopPropagation()
                        this.props.WPSceneStore.changeItemProps({
                          [`visualElement.${item.key}`]: ''
                        })
                      }}
                    />
                  )}
                </div>
              </div>
            )
          })}
          <div className={Style.item_line}>
            <p className={Style.item_line_title}>边框颜色</p>
            <div style={{ width: 65 }}>
              <ColorPicker
                value={visualElement.borderColor}
                size="small"
                placement="right"
                onChange={color =>
                  this.props.WPSceneStore.changeItemProps({
                    'visualElement.borderColor': color
                  })
                }
              />
            </div>
          </div>
        </div>
        <div className={Style.right_section}>
          <div className={Style.right_section_inner}>
            <div className={Style.preview} style={{ backgroundImage: `url("${staticResourcePrefix}/masker@2x.png")` }}>
              <img src={visualElement[activeKey]} />
              {visualElement[activeKey] !== defaultAttrs.visualElement[activeKey] && (
                <div
                  className={Style.restore}
                  onClick={() => {
                    this.props.WPSceneStore.changeItemProps({
                      [`visualElement.${activeKey}`]: defaultAttrs.visualElement[activeKey]
                    })
                  }}
                >
                  <TuiaIcon type="icon-system_recovery" />
                  恢复默认
                </div>
              )}
            </div>
            <Upload
              name="file"
              showUploadList={false}
              action={uploadUrl}
              data={{
                path: uploadBucket,
                isTinypng: false
              }}
              beforeUpload={beforeUploadGen({
                maxSize: 1,
                onEnd: ({ typeError, sizeError }) => {
                  this.setState({
                    sizeError,
                    typeError
                  })
                }
              })}
              onChange={uploadStatusChangeGen(info => {
                const { activeKey } = this.state
                if (info.file.status === 'uploading') {
                  this.setState({ loading: true })
                  return
                }
                if (info.file.status === 'done') {
                  const netUrl = `${imagePrefix}${uploadBucket}${info.file.name}`
                  this.props.WPSceneStore.changeItemProps({
                    [`visualElement.${activeKey}`]: netUrl
                  })
                  this.setState({ loading: false })
                  readImageProps(netUrl).then((result) => {
                    const dpr = this.props.WPSceneStore.scene.dpr
                    if (result.width !== width * dpr || result.height !== height * dpr) {
                      TriggerableGuide.show({
                        id: '__upload_size__',
                        theme: 'none',
                        placement: 'top',
                        domId: '__upload_size__',
                        text: UploadErrorGuider,
                        introOffset: {
                          bottom: 10,
                          left: -100
                        },
                        arrowOffset: {
                          bottom: 10,
                          left: -100
                        },
                        onShow: () => {
                          this.setState({
                            dimensionError: true
                          })
                        },
                        onCancel: () => {
                          this.setState({
                            dimensionError: false
                          })
                        }
                      })
                    }
                  })
                } else if (info.file.status === 'error') {
                  message.error(`${info.file.name}。文件上传失败`)
                  this.setState({ loading: false })
                }
              })}
            >
              {loading ? <Spin /> : <p className={Style.change_btn}>更换图片</p>}
            </Upload>
            <div className={Style.upload_des}>
              <p
                id="__upload_size__"
                style={{
                  color: this.state.dimensionError
                    ? CommonStyles['@primary-assist-color']
                    : CommonStyles['@third-font-color']
                }}
              >
                标准尺寸：{width}px*{height}px
              </p>
              <p
                style={{
                  color: this.state.typeError
                    ? CommonStyles['@primary-assist-color']
                    : CommonStyles['@third-font-color']
                }}
              >
                上传格式：JPG/JPEG/PNG
              </p>
              <p
                style={{
                  color: this.state.sizeError
                    ? CommonStyles['@primary-assist-color']
                    : CommonStyles['@third-font-color']
                }}
              >
                文件大小：不大于1M
              </p>
            </div>
          </div>
        </div>
      </div>
    )
  }
}
